/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.projectnessie.client.auth.AwsAuthenticationProvider;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.auth.NessieAuthenticationProvider;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpHeaders;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.RequestFilter;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.profiles.ProfileFileSystemSetting;
import software.amazon.awssdk.regions.Region;

class TestAwsAuthProvider {
    TestAwsAuthProvider() {
    }

    @AfterEach
    void cleanupSystemProperties() {
        System.getProperties().remove(SdkSystemSetting.AWS_ACCESS_KEY_ID.property());
        System.getProperties().remove(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property());
        System.getProperties().remove(ProfileFileSystemSetting.AWS_SHARED_CREDENTIALS_FILE.property());
    }

    @Test
    void testAws() {
        ImmutableMap authCfg = ImmutableMap.of((Object)"nessie.authentication.type", (Object)"AWS", (Object)"nessie.authentication.aws.region", (Object)"eu-central-1");
        ((ObjectAssert)Assertions.assertThat((Object)NessieAuthenticationProvider.fromConfig(((Map)authCfg)::get)).isNotNull()).extracting(Object::getClass).extracting(Class::getSimpleName).isEqualTo((Object)"AwsAuthentication");
        authCfg = ImmutableMap.of((Object)"nessie.authentication.type", (Object)"AWS");
        ((ObjectAssert)Assertions.assertThat((Object)NessieAuthenticationProvider.fromConfig(((Map)authCfg)::get)).isNotNull()).extracting(Object::getClass).extracting(Class::getSimpleName).isEqualTo((Object)"AwsAuthentication");
        ImmutableMap authCfgErr = ImmutableMap.of((Object)"nessie.authentication.type", (Object)"AWS", (Object)"nessie.authentication.aws.region", (Object)"not-on-this-planet-1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> NessieAuthenticationProvider.fromConfig(arg_0 -> ((ImmutableMap)authCfgErr).get(arg_0))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unknown region 'not-on-this-planet-1'.");
    }

    @Test
    void testFromConfig() {
        ImmutableMap authCfg = ImmutableMap.of((Object)"nessie.authentication.type", (Object)"AWS");
        NessieAuthentication authentication = NessieAuthenticationProvider.fromConfig(((Map)authCfg)::get);
        System.setProperty(SdkSystemSetting.AWS_ACCESS_KEY_ID.property(), "testFromConfig");
        System.setProperty(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), "test_secret");
        this.checkAuth(authentication, Region.US_WEST_2.toString(), "testFromConfig");
    }

    @Test
    void testStaticBuilder() {
        System.setProperty(SdkSystemSetting.AWS_ACCESS_KEY_ID.property(), "testStaticBuilder");
        System.setProperty(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), "test_secret");
        this.checkAuth((NessieAuthentication)AwsAuthenticationProvider.create((Region)Region.AWS_GLOBAL), Region.AWS_GLOBAL.toString(), "testStaticBuilder");
    }

    @Test
    void testFromConfigWithProfile(@TempDir File configDir) throws IOException {
        ImmutableMap authCfg = ImmutableMap.builder().put((Object)"nessie.authentication.type", (Object)"AWS").put((Object)"nessie.authentication.aws.region", (Object)Region.US_EAST_1.toString()).put((Object)"nessie.authentication.aws.profile", (Object)"test2").build();
        NessieAuthentication authentication = NessieAuthenticationProvider.fromConfig(((Map)authCfg)::get);
        this.writeAwsProfile(configDir, "test2", "testFromConfigWithProfile");
        this.checkAuth(authentication, Region.US_EAST_1.toString(), "testFromConfigWithProfile");
    }

    @Test
    void testStaticBuilderWithProfile(@TempDir File configDir) throws IOException {
        this.writeAwsProfile(configDir, "test1", "testStaticBuilderWithProfile");
        this.checkAuth((NessieAuthentication)AwsAuthenticationProvider.create((Region)Region.AWS_GLOBAL, (String)"test1"), Region.AWS_GLOBAL.toString(), "testStaticBuilderWithProfile");
    }

    void writeAwsProfile(File configDir, String profileName, String keyId) throws IOException {
        File credentials = new File(configDir, "aws.credentials");
        Files.write(credentials.toPath(), (Iterable<? extends CharSequence>)ImmutableList.of((Object)("[" + profileName + "]"), (Object)("aws_access_key_id=" + keyId), (Object)"aws_secret_access_key=test1_secret", (Object)"aws_session_token=test1_session"), StandardCharsets.UTF_8, StandardOpenOption.CREATE);
        System.setProperty(ProfileFileSystemSetting.AWS_SHARED_CREDENTIALS_FILE.property(), credentials.getAbsolutePath());
    }

    void checkAuth(NessieAuthentication authentication, String expectedRegion, String expectedKeyId) {
        Assertions.assertThat((Object)authentication).isInstanceOf(HttpAuthentication.class);
        HttpAuthentication httpAuthentication = (HttpAuthentication)authentication;
        RequestFilter[] authFilter = new RequestFilter[1];
        HttpClient.Builder client = (HttpClient.Builder)Mockito.mock(HttpClient.Builder.class);
        ((HttpClient.Builder)Mockito.doAnswer(invocationOnMock -> {
            Object[] args = invocationOnMock.getArguments();
            if (args.length == 1 && args[0] instanceof RequestFilter && args[0].getClass().getSimpleName().equalsIgnoreCase("AwsHttpAuthenticationFilter")) {
                authFilter[0] = (RequestFilter)args[0];
            }
            return null;
        }).when((Object)client)).addRequestFilter((RequestFilter)Mockito.any());
        httpAuthentication.applyToHttpClient(client);
        Assertions.assertThat((Object)authFilter[0]).isInstanceOf(RequestFilter.class);
        HttpHeaders headers = new HttpHeaders();
        RequestContext context = new RequestContext(headers, URI.create("http://localhost/"), HttpClient.Method.GET, null);
        authFilter[0].filter(context);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((IterableAssert)((MapAssert)((MapAssert)Assertions.assertThat((Map)headers.asMap()).containsKey((Object)"Authorization")).containsKey((Object)"X-Amz-Date")).extracting("Authorization", InstanceOfAssertFactories.iterable(String.class))).first(InstanceOfAssertFactories.STRING)).containsSequence(new CharSequence[]{expectedRegion})).containsSequence(new CharSequence[]{expectedKeyId})).containsSequence(new CharSequence[]{"Signature="})).containsSequence(new CharSequence[]{"Credential="});
    }
}

