/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.net.URI;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.client.http.UriBuilder;

class TestUriBuilder {
    TestUriBuilder() {
    }

    @Test
    void simple() {
        Assertions.assertEquals((Object)"http://localhost/foo/bar/", (Object)new UriBuilder(URI.create("http://localhost/foo/bar/")).build().toString());
    }

    @Test
    void parameterValidation() {
        Assertions.assertAll((Executable[])new Executable[]{() -> Assertions.assertThrows(NullPointerException.class, () -> new UriBuilder(null)), () -> Assertions.assertThrows(NullPointerException.class, () -> new UriBuilder(URI.create("http://base/")).path(null)), () -> Assertions.assertThrows(NullPointerException.class, () -> new UriBuilder(URI.create("http://base/")).resolveTemplate(null, "value")), () -> Assertions.assertThrows(NullPointerException.class, () -> new UriBuilder(URI.create("http://base/")).resolveTemplate("name", null))});
    }

    @Test
    void addMissingSlash() {
        Assertions.assertEquals((Object)"http://localhost/", (Object)new UriBuilder(URI.create("http://localhost")).build().toString());
        Assertions.assertEquals((Object)"http://localhost/foo/bar", (Object)new UriBuilder(URI.create("http://localhost")).path("foo").path("bar").build().toString());
    }

    @Test
    void pathTemplates() {
        UriBuilder builder = new UriBuilder(URI.create("http://localhost/foo/bar/"));
        builder = builder.path("{my-var}").resolveTemplate("my-var", "baz");
        Assertions.assertEquals((Object)"http://localhost/foo/bar/baz", (Object)builder.build().toString());
        builder = builder.path("something/{in}/here").resolveTemplate("in", "out");
        Assertions.assertEquals((Object)"http://localhost/foo/bar/baz/something/out/here", (Object)builder.build().toString());
        UriBuilder bulder1 = builder = builder.resolveTemplate("no", "boo");
        Assertions.assertEquals((Object)String.format("Cannot build uri. Not all template keys (%s) were used in uri %s", "no", "{my-var}/something/{in}/here"), (Object)((HttpClientException)Assertions.assertThrows(HttpClientException.class, () -> ((UriBuilder)bulder1).build())).getMessage());
    }

    @Test
    void pathEncoding() {
        UriBuilder builder = new UriBuilder(URI.create("http://localhost/foo/bar/"));
        builder = builder.path("some spaces in here");
        Assertions.assertEquals((Object)"http://localhost/foo/bar/some%20spaces%20in%20here", (Object)builder.build().toString());
    }

    @Test
    void adjacentTemplates() {
        UriBuilder builder = new UriBuilder(URI.create("http://localhost/foo/bar/")).path("{foo}{bar}..{woof}{meow}..{meep}{moo}").resolveTemplate("foo", "baz").resolveTemplate("bar", "").resolveTemplate("woof", "dog/").resolveTemplate("meow", "cat").resolveTemplate("meep", "bird").resolveTemplate("moo", "cow");
        Assertions.assertEquals((Object)"http://localhost/foo/bar/baz..dog%2Fcat..birdcow", (Object)builder.build().toString());
    }

    @Test
    void queryParameters() {
        UriBuilder builder = new UriBuilder(URI.create("http://localhost/foo/bar/"));
        builder = builder.queryParam("a", "b");
        Assertions.assertEquals((Object)"http://localhost/foo/bar/?a=b", (Object)builder.build().toString());
        builder = builder.queryParam("c", "d");
        Assertions.assertEquals((Object)"http://localhost/foo/bar/?a=b&c=d", (Object)builder.build().toString());
        builder = builder.queryParam("e", "f&? /");
        Assertions.assertEquals((Object)"http://localhost/foo/bar/?a=b&c=d&e=f%26%3F%20%2F", (Object)builder.build().toString());
        builder = builder.queryParam("c", "d-more");
        Assertions.assertEquals((Object)"http://localhost/foo/bar/?a=b&c=d&e=f%26%3F%20%2F&c=d-more", (Object)builder.build().toString());
    }
}

