/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import com.sun.net.httpserver.HttpHandler;
import io.opentracing.Scope;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.client.util.JaegerTestTracer;
import org.projectnessie.client.util.TestHttpUtil;
import org.projectnessie.client.util.TestServer;

class TestNessieHttpClient {
    TestNessieHttpClient() {
    }

    @BeforeAll
    static void setupTracer() {
        JaegerTestTracer.register();
    }

    @Test
    void testTracing() throws Exception {
        AtomicReference<String> traceId = new AtomicReference<String>();
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Uber-trace-id", traceId));){
            NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri()).withTracing(true).build(NessieApiV1.class);
            try (Scope ignore = GlobalTracer.get().activateSpan(GlobalTracer.get().buildSpan("testOpenTracing").start());){
                api.getConfig();
            }
        }
        org.junit.jupiter.api.Assertions.assertNotNull((Object)traceId.get());
    }

    @Test
    void testTracingNotEnabled() throws Exception {
        AtomicReference<String> traceId = new AtomicReference<String>();
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Uber-trace-id", traceId));){
            NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri()).withTracing(false).build(NessieApiV1.class);
            try (Scope ignore = GlobalTracer.get().activateSpan(GlobalTracer.get().buildSpan("testOpenTracing").start());){
                api.getConfig();
            }
        }
        org.junit.jupiter.api.Assertions.assertNull((Object)traceId.get());
    }

    private TestServer errorServer(int status) throws IOException {
        return new TestServer(h -> {
            h.sendResponseHeaders(status, 0L);
            h.getResponseBody().close();
        });
    }

    @Test
    void testNotFoundOnBaseUri() throws IOException {
        try (TestServer server = this.errorServer(404);){
            NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri().resolve("/unknownPath")).build(NessieApiV1.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((NessieApiV1)api).getConfig()).isInstanceOf(RuntimeException.class)).hasMessageContaining("Not Found");
        }
    }

    @Test
    void testInternalServerError() throws IOException {
        try (TestServer server = this.errorServer(500);){
            NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri().resolve("/broken")).build(NessieApiV1.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((NessieApiV1)api).getConfig()).isInstanceOf(NessieInternalServerException.class)).hasMessageContaining("Internal Server Error");
        }
    }

    @Test
    void testUnauthorized() throws IOException {
        try (TestServer server = this.errorServer(401);){
            NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri().resolve("/unauthorized")).build(NessieApiV1.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((NessieApiV1)api).getConfig()).isInstanceOf(NessieNotAuthorizedException.class)).hasMessageContaining("Unauthorized");
        }
    }

    static HttpHandler handlerForHeaderTest(String headerName, AtomicReference<String> receiver) {
        return h -> {
            receiver.set(h.getRequestHeaders().getFirst(headerName));
            h.getRequestBody().close();
            TestHttpUtil.writeResponseBody(h, "{\"maxSupportedApiVersion\":1}");
        };
    }
}

