/*
 * Copyright (C) 2020 Dremio
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.dremio.nessie.client.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;

import com.dremio.nessie.client.http.RequestContext;
import com.dremio.nessie.client.http.RequestFilter;

/**
 * Filter to add auth header to all outgoing requests.
 */
public class BasicAuthFilter implements RequestFilter {

  private final String authHeaderValue;

  /**
   * construct auth filter depending on auth type.
   *
   * @param username username (only for BASIC auth)
   * @param password password (only for BASIC auth)
   */
  public BasicAuthFilter(String username, String password) {
    Objects.requireNonNull(username, "username for BasicAuthFilter must not be null");
    Objects.requireNonNull(password, "password for BasicAuthFilter must not be null");
    String userPass = username + ':' + password;
    byte[] encoded = Base64.getEncoder().encode(userPass.getBytes(StandardCharsets.UTF_8));
    String encodedString = new String(encoded, StandardCharsets.UTF_8);
    authHeaderValue = "Basic " + encodedString;
  }

  @Override
  public void filter(RequestContext context) {
    context.putHeader("Authorization", authHeaderValue);
  }

}
