/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client.http;

import com.dremio.nessie.client.http.HttpClient;
import com.dremio.nessie.client.http.HttpClientException;
import com.dremio.nessie.client.http.HttpRequest;
import com.dremio.nessie.client.http.TestServer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.io.BaseEncoding;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsParameters;
import com.sun.net.httpserver.HttpsServer;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.time.ZonedDateTime;
import java.util.Date;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500NameBuilder;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestHttpsClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestHttpsClient.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    TestHttpsClient() {
    }

    @Test
    void testHttps() throws Exception {
        HttpHandler handler = h -> {
            Assertions.assertEquals((Object)"GET", (Object)h.getRequestMethod());
            String response = "hello";
            h.sendResponseHeaders(200, response.getBytes().length);
            OutputStream os = h.getResponseBody();
            os.write(response.getBytes());
            os.close();
        };
        TrustManager[][] trustManager = new TrustManager[1][];
        try (TestServer server = new TestServer("/", handler, s -> {
            try {
                trustManager[0] = TestHttpsClient.ssl(s);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });){
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustManager[0], new SecureRandom());
            HttpRequest client = HttpClient.builder().setBaseUri("https://localhost:" + server.server.getAddress().getPort()).setObjectMapper(MAPPER).setSslContext(sc).build().newRequest();
            client.get();
            HttpRequest insecureClient = HttpClient.builder().setBaseUri("https://localhost:" + server.server.getAddress().getPort()).setObjectMapper(MAPPER).build().newRequest();
            Assertions.assertThrows(HttpClientException.class, () -> ((HttpRequest)insecureClient).get());
        }
    }

    private static KeyPair generateKeyPair(SecureRandom random) throws Exception {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048, random);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return keyPair;
    }

    private static X509CertificateHolder generateCertHolder(SecureRandom random, ZonedDateTime now, KeyPair keyPair) throws Exception {
        ContentSigner contentSigner;
        X500NameBuilder nameBuilder = new X500NameBuilder(BCStyle.INSTANCE).addRDN(BCStyle.CN, "localhost").addRDN(BCStyle.OU, "Dremio Corp. (auto-generated)").addRDN(BCStyle.O, "Dremio Corp. (auto-generated)").addRDN(BCStyle.L, "Mountain View").addRDN(BCStyle.ST, "California").addRDN(BCStyle.C, "US");
        Date notBefore = Date.from(now.minusDays(1L).toInstant());
        Date notAfter = Date.from(now.plusYears(1L).toInstant());
        BigInteger serialNumber = new BigInteger(128, random);
        GeneralName[] alternativeSubjectNames = new GeneralName[]{new GeneralName(2, "localhost")};
        X509v3CertificateBuilder certificateBuilder = new JcaX509v3CertificateBuilder(nameBuilder.build(), serialNumber, notBefore, notAfter, nameBuilder.build(), keyPair.getPublic()).addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)new DERSequence((ASN1Encodable[])alternativeSubjectNames));
        try {
            contentSigner = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(keyPair.getPrivate());
        }
        catch (OperatorCreationException e) {
            throw new GeneralSecurityException(e);
        }
        return certificateBuilder.build(contentSigner);
    }

    private static X509Certificate generateCert(ZonedDateTime now, X509CertificateHolder certHolder) throws Exception {
        X509Certificate certificate = new JcaX509CertificateConverter().getCertificate(certHolder);
        certificate.checkValidity(Date.from(now.toInstant()));
        certificate.verify(certificate.getPublicKey());
        String fingerprint = BaseEncoding.base16().withSeparator(":", 2).encode(MessageDigest.getInstance("SHA-256").digest(certificate.getEncoded()));
        LOGGER.info("Certificate created (SHA-256 fingerprint: {})", (Object)fingerprint);
        return certificate;
    }

    private static TrustManager[] ssl(HttpServer httpsServer) throws Exception {
        SSLContext sslContext = SSLContext.getInstance("TLS");
        String storeType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(storeType);
        KeyStore trustStore = KeyStore.getInstance(storeType);
        keyStore.load(null, null);
        trustStore.load(null, null);
        ZonedDateTime now = ZonedDateTime.now();
        SecureRandom random = new SecureRandom();
        KeyPair keyPair = TestHttpsClient.generateKeyPair(random);
        X509CertificateHolder certHolder = TestHttpsClient.generateCertHolder(random, now, keyPair);
        X509Certificate certificate = TestHttpsClient.generateCert(now, certHolder);
        keyStore.setKeyEntry("AutoGeneratedPrivateKey", keyPair.getPrivate(), "password".toCharArray(), new Certificate[]{certificate});
        trustStore.setEntry("AutoGeneratedCert", new KeyStore.TrustedCertificateEntry(certificate), null);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, "password".toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(keyStore);
        sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        ((HttpsServer)httpsServer).setHttpsConfigurator(new HttpsConfigurator(sslContext){

            @Override
            public void configure(HttpsParameters params) {
                try {
                    SSLContext c = SSLContext.getDefault();
                    SSLEngine engine = c.createSSLEngine();
                    params.setNeedClientAuth(false);
                    params.setCipherSuites(engine.getEnabledCipherSuites());
                    params.setProtocols(engine.getEnabledProtocols());
                    SSLParameters defaultSSLParameters = c.getDefaultSSLParameters();
                    params.setSSLParameters(defaultSSLParameters);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        return tmf.getTrustManagers();
    }
}

