/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client.http;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.function.Consumer;

class TestServer
implements AutoCloseable {
    final HttpServer server;

    TestServer(String context, HttpHandler handler) throws IOException {
        this(context, handler, null);
    }

    TestServer(String context, HttpHandler handler, Consumer<HttpsServer> init) throws IOException {
        HttpHandler safeHandler = exchange -> {
            try {
                handler.handle(exchange);
            }
            catch (Error | RuntimeException e) {
                exchange.sendResponseHeaders(503, 0L);
                throw e;
            }
        };
        if (init == null) {
            this.server = HttpServer.create(new InetSocketAddress("localhost", 0), 0);
        } else {
            this.server = HttpsServer.create(new InetSocketAddress("localhost", 0), 0);
            init.accept((HttpsServer)this.server);
        }
        this.server.createContext(context, safeHandler);
        this.server.setExecutor(null);
        this.server.start();
    }

    TestServer(HttpHandler handler) throws IOException {
        this("/", handler);
    }

    @Override
    public void close() throws Exception {
        this.server.stop(0);
    }
}

