/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client.rest;

import com.dremio.nessie.client.http.ResponseContext;
import com.dremio.nessie.client.http.Status;
import com.dremio.nessie.client.rest.NessieBadRequestException;
import com.dremio.nessie.client.rest.NessieForbiddenException;
import com.dremio.nessie.client.rest.NessieInternalServerException;
import com.dremio.nessie.client.rest.NessieNotAuthorizedException;
import com.dremio.nessie.client.rest.NessieServiceException;
import com.dremio.nessie.client.rest.ResponseCheckFilter;
import com.dremio.nessie.error.BaseNessieClientServerException;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieError;
import com.dremio.nessie.error.NessieNotFoundException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import software.amazon.awssdk.utils.StringInputStream;

public class TestResponseFilter {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @ParameterizedTest
    @MethodSource(value={"provider"})
    void testRepsonseFilter(Status responseCode, Class<? extends Exception> clazz) {
        block3: {
            NessieError error = new NessieError(responseCode.getCode(), responseCode.getReason(), "xxx", null);
            try {
                ResponseCheckFilter.checkResponse((ResponseContext)new TestResponseContext(responseCode, error), (ObjectMapper)MAPPER);
            }
            catch (Exception e) {
                Assertions.assertTrue((boolean)clazz.isInstance(e));
                if (e instanceof NessieServiceException) {
                    Assertions.assertEquals((Object)((NessieServiceException)e).getError(), (Object)error);
                }
                if (!(e instanceof BaseNessieClientServerException)) break block3;
                Assertions.assertEquals((int)((BaseNessieClientServerException)e).getStatus(), (int)error.getStatus());
                Assertions.assertEquals((Object)((BaseNessieClientServerException)e).getServerStackTrace(), (Object)error.getServerStackTrace());
            }
        }
    }

    @Test
    void testBadReturn() throws IOException {
        NessieError error = new NessieError("unknown", 415, "xxx", null);
        try {
            ResponseCheckFilter.checkResponse((ResponseContext)new TestResponseContext(Status.UNSUPPORTED_MEDIA_TYPE, error), (ObjectMapper)MAPPER);
        }
        catch (NessieServiceException e) {
            Assertions.assertEquals((Object)error, (Object)e.getError());
        }
    }

    @Test
    void testBadReturnNoError() throws IOException {
        try {
            ResponseCheckFilter.checkResponse((ResponseContext)new ResponseContext(){

                public Status getResponseCode() {
                    return Status.UNAUTHORIZED;
                }

                public InputStream getInputStream() {
                    Assertions.fail();
                    return null;
                }

                public InputStream getErrorStream() {
                    return new StringInputStream("this will fail");
                }
            }, (ObjectMapper)MAPPER);
        }
        catch (NessieServiceException e) {
            Assertions.assertEquals((int)Status.UNAUTHORIZED.getCode(), (int)e.getError().getStatus());
            Assertions.assertTrue((boolean)(e.getError().getClientProcessingException() instanceof IOException));
            Assertions.assertNull((Object)e.getError().getServerStackTrace());
        }
    }

    @Test
    void testBadReturnBadError() throws IOException {
        try {
            ResponseCheckFilter.checkResponse((ResponseContext)new TestResponseContext(Status.UNAUTHORIZED, null), (ObjectMapper)MAPPER);
        }
        catch (NessieServiceException e) {
            NessieError defaultError = new NessieError(Status.UNAUTHORIZED.getCode(), Status.UNAUTHORIZED.getReason(), "Could not parse error object in response.", (Exception)new RuntimeException("Could not parse error object in response."));
            Assertions.assertEquals((Object)defaultError, (Object)e.getError());
        }
    }

    @Test
    void testGood() {
        Assertions.assertDoesNotThrow(() -> ResponseCheckFilter.checkResponse((ResponseContext)new TestResponseContext(Status.OK, null), (ObjectMapper)MAPPER));
    }

    private static Stream<Arguments> provider() {
        return Stream.of(Arguments.of((Object[])new Object[]{Status.BAD_REQUEST, NessieBadRequestException.class}), Arguments.of((Object[])new Object[]{Status.UNAUTHORIZED, NessieNotAuthorizedException.class}), Arguments.of((Object[])new Object[]{Status.FORBIDDEN, NessieForbiddenException.class}), Arguments.of((Object[])new Object[]{Status.NOT_FOUND, NessieNotFoundException.class}), Arguments.of((Object[])new Object[]{Status.CONFLICT, NessieConflictException.class}), Arguments.of((Object[])new Object[]{Status.INTERNAL_SERVER_ERROR, NessieInternalServerException.class}));
    }

    private static class TestResponseContext
    implements ResponseContext {
        private final Status code;
        private final NessieError error;

        TestResponseContext(Status code, NessieError error) {
            this.code = code;
            this.error = error;
        }

        public Status getResponseCode() throws IOException {
            return this.code;
        }

        public InputStream getInputStream() throws IOException {
            Assertions.fail();
            return null;
        }

        public InputStream getErrorStream() throws IOException {
            if (this.error == null) {
                return null;
            }
            String value = MAPPER.writeValueAsString((Object)this.error);
            return new StringInputStream(value);
        }
    }
}

