/*
 * Decompiled with CFR 0.152.
 */
package com.dremio.nessie.client;

import com.dremio.nessie.api.ContentsApi;
import com.dremio.nessie.client.http.HttpClient;
import com.dremio.nessie.error.NessieConflictException;
import com.dremio.nessie.error.NessieNotFoundException;
import com.dremio.nessie.model.Contents;
import com.dremio.nessie.model.ContentsKey;
import com.dremio.nessie.model.MultiGetContentsRequest;
import com.dremio.nessie.model.MultiGetContentsResponse;
import javax.validation.constraints.NotNull;

class ClientContentsApi
implements ContentsApi {
    private final HttpClient client;

    public ClientContentsApi(HttpClient client) {
        this.client = client;
    }

    public Contents getContents(@NotNull ContentsKey key, String ref) throws NessieNotFoundException {
        return this.client.newRequest().path("contents").path(key.toPathString()).queryParam("ref", ref).get().readEntity(Contents.class);
    }

    public MultiGetContentsResponse getMultipleContents(@NotNull String ref, @NotNull MultiGetContentsRequest request) throws NessieNotFoundException {
        return this.client.newRequest().path("contents").queryParam("ref", ref).post(request).readEntity(MultiGetContentsResponse.class);
    }

    public void setContents(@NotNull ContentsKey key, String branch, @NotNull String hash, String message, @NotNull Contents contents) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("contents").path(key.toPathString()).queryParam("branch", branch).queryParam("hash", hash).queryParam("message", message).post(contents);
    }

    public void deleteContents(ContentsKey key, String branch, String hash, String message) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("contents").path(key.toPathString()).queryParam("branch", branch).queryParam("hash", hash).queryParam("message", message).delete();
    }
}

