/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import com.sun.net.httpserver.HttpHandler;
import io.jaegertracing.internal.JaegerTracer;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.util.TestServer;

class TestNessieHttpClient {
    TestNessieHttpClient() {
    }

    @BeforeAll
    static void setupTracer() {
        GlobalTracer.register((Tracer)new JaegerTracer.Builder("TestNessieHttpClient").build());
    }

    @Test
    void testNullUri() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> {
            NessieClient nessieClient = NessieClient.builder().withUri(null).build();
        });
    }

    @Test
    void testAuthBasic() throws Exception {
        AtomicReference<String> authHeader = new AtomicReference<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Authorization", authHeader));){
            NessieClient client = NessieClient.builder().withUri(server.getUri()).withAuthType(NessieClient.AuthType.BASIC).withUsername("my_username").withPassword("very_secret").build();
            client.getConfigApi().getConfig();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assertions.assertEquals((Object)("Basic " + new String(Base64.getUrlEncoder().encode("my_username:very_secret".getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8)), (Object)authHeader.get());
    }

    @Test
    void testTracing() throws Exception {
        AtomicReference<String> traceId = new AtomicReference<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Uber-trace-id", traceId));){
            NessieClient client = NessieClient.builder().withUri(server.getUri()).withTracing(true).build();
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (Scope ignore = GlobalTracer.get().buildSpan("testOpenTracing").startActive(true);){
                client.getConfigApi().getConfig();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        Assertions.assertNotNull((Object)traceId.get());
    }

    @Test
    void testTracingNotEnabled() throws Exception {
        AtomicReference<String> traceId = new AtomicReference<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Uber-trace-id", traceId));){
            NessieClient client = NessieClient.builder().withUri(server.getUri()).withTracing(false).build();
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (Scope ignore = GlobalTracer.get().buildSpan("testOpenTracing").startActive(true);){
                client.getConfigApi().getConfig();
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
        Assertions.assertNull((Object)traceId.get());
    }

    static HttpHandler handlerForHeaderTest(String headerName, AtomicReference<String> receiver) {
        return h -> {
            receiver.set(h.getRequestHeaders().getFirst(headerName));
            h.getRequestBody().close();
            h.sendResponseHeaders(200, 2L);
            Throwable throwable = null;
            Object var4_5 = null;
            try (OutputStream out = h.getResponseBody();){
                out.write("{}".getBytes(StandardCharsets.UTF_8));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        };
    }
}

