/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import javax.validation.constraints.NotNull;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.MultiGetContentsRequest;
import org.projectnessie.model.MultiGetContentsResponse;

class ClientContentsApi
implements ContentsApi {
    private final HttpClient client;

    public ClientContentsApi(HttpClient client) {
        this.client = client;
    }

    public Contents getContents(@NotNull ContentsKey key, String ref) throws NessieNotFoundException {
        return this.client.newRequest().path("contents").path(key.toPathString()).queryParam("ref", ref).get().readEntity(Contents.class);
    }

    public MultiGetContentsResponse getMultipleContents(@NotNull String ref, @NotNull MultiGetContentsRequest request) throws NessieNotFoundException {
        return this.client.newRequest().path("contents").queryParam("ref", ref).post(request).readEntity(MultiGetContentsResponse.class);
    }

    public void setContents(@NotNull ContentsKey key, String branch, @NotNull String hash, String message, @NotNull Contents contents) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("contents").path(key.toPathString()).queryParam("branch", branch).queryParam("hash", hash).queryParam("message", message).post(contents);
    }

    public void deleteContents(ContentsKey key, String branch, String hash, String message) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("contents").path(key.toPathString()).queryParam("branch", branch).queryParam("hash", hash).queryParam("message", message).delete();
    }
}

