/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.net.URLConnection;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.projectnessie.client.http.HttpHeaders;

@Execution(value=ExecutionMode.CONCURRENT)
public class TestHttpHeaders {
    @Test
    public void multipleValues() {
        HttpHeaders headers = new HttpHeaders();
        headers.put("Abc", "def");
        headers.put("abc", "ghi");
        headers.put("aBc", "jkl");
        Assertions.assertThat((Map)headers.asMap()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"Abc", new LinkedHashSet<String>(Arrays.asList("def", "ghi", "jkl")))});
        Assertions.assertThat((Iterable)headers.getValues("abc")).containsExactly((Object[])new String[]{"def", "ghi", "jkl"});
    }

    @Test
    public void notPresent() {
        HttpHeaders headers = new HttpHeaders();
        Assertions.assertThat((Iterable)headers.getValues("notThere")).isEmpty();
    }

    @Test
    public void applyToUrlConnection() {
        HttpHeaders headers = new HttpHeaders();
        headers.put("Abc", "def");
        headers.put("abc", "ghi");
        headers.put("aBc", "jkl");
        headers.put("Foo-Bar", "Baz");
        URLConnection urlConnectionMock = (URLConnection)Mockito.mock(URLConnection.class);
        ArgumentCaptor nameCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor valueCaptor = ArgumentCaptor.forClass(String.class);
        headers.applyTo(urlConnectionMock);
        ((URLConnection)Mockito.verify((Object)urlConnectionMock, (VerificationMode)Mockito.times((int)4))).addRequestProperty((String)nameCaptor.capture(), (String)valueCaptor.capture());
        Assertions.assertThat((List)nameCaptor.getAllValues()).containsExactly((Object[])new String[]{"Abc", "Abc", "Abc", "Foo-Bar"});
        Assertions.assertThat((List)valueCaptor.getAllValues()).containsExactly((Object[])new String[]{"def", "ghi", "jkl", "Baz"});
    }
}

