/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import java.util.List;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.projectnessie.client.ResultStreamPaginator;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.GetRefLogBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.api.PagingBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.PaginatedResponse;
import org.projectnessie.model.RefLogResponse;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;

public final class StreamingUtil {
    private StreamingUtil() {
    }

    @Deprecated
    public static Stream<Reference> getAllReferencesStream(@NotNull NessieApiV1 api, @NotNull Function<GetAllReferencesBuilder, GetAllReferencesBuilder> builderCustomizer, @NotNull OptionalInt pageSizeHint) throws NessieNotFoundException {
        GetAllReferencesBuilder builder = builderCustomizer.apply(api.getAllReferences());
        Integer pageSize = pageSizeHint.isPresent() ? Integer.valueOf(pageSizeHint.getAsInt()) : null;
        return new ResultStreamPaginator(ReferencesResponse::getReferences, token -> StreamingUtil.builderWithPaging(builder, pageSize, token).get()).generateStream();
    }

    @Deprecated
    public static Stream<EntriesResponse.Entry> getEntriesStream(@NotNull NessieApiV1 api, @NotNull Function<GetEntriesBuilder, GetEntriesBuilder> builderCustomizer, @NotNull OptionalInt pageSizeHint) throws NessieNotFoundException {
        GetEntriesBuilder builder = builderCustomizer.apply(api.getEntries());
        Integer pageSize = pageSizeHint.isPresent() ? Integer.valueOf(pageSizeHint.getAsInt()) : null;
        return new ResultStreamPaginator(EntriesResponse::getEntries, token -> (EntriesResponse)StreamingUtil.builderWithPaging(builder, pageSize, token).get()).generateStream();
    }

    @Deprecated
    public static Stream<LogResponse.LogEntry> getCommitLogStream(@NotNull NessieApiV1 api, @NotNull Function<GetCommitLogBuilder, GetCommitLogBuilder> builderCustomizer, @NotNull OptionalInt pageSizeHint) throws NessieNotFoundException {
        GetCommitLogBuilder builder = builderCustomizer.apply(api.getCommitLog());
        Integer pageSize = pageSizeHint.isPresent() ? Integer.valueOf(pageSizeHint.getAsInt()) : null;
        return new ResultStreamPaginator(LogResponse::getLogEntries, token -> (LogResponse)StreamingUtil.builderWithPaging(builder, pageSize, token).get()).generateStream();
    }

    @Deprecated
    public static Stream<RefLogResponse.RefLogResponseEntry> getReflogStream(@NotNull NessieApiV1 api, @NotNull Function<GetRefLogBuilder, GetRefLogBuilder> builderCustomizer, @NotNull OptionalInt pageSizeHint) throws NessieNotFoundException {
        GetRefLogBuilder builder = builderCustomizer.apply(api.getRefLog());
        Integer pageSize = pageSizeHint.isPresent() ? Integer.valueOf(pageSizeHint.getAsInt()) : null;
        return new ResultStreamPaginator(RefLogResponse::getLogEntries, token -> (RefLogResponse)StreamingUtil.builderWithPaging(builder, pageSize, token).get()).generateStream();
    }

    private static <B extends PagingBuilder<B, ?, ?>> B builderWithPaging(B builder, Integer pageSize, String token) {
        if (pageSize != null) {
            builder.maxRecords(pageSize);
        }
        if (token != null) {
            builder.pageToken(token);
        }
        return builder;
    }

    public static <ENTRY, RESP extends PaginatedResponse> Stream<ENTRY> generateStream(Function<RESP, List<ENTRY>> entriesExtractor, NextPage<RESP> pageFetcher) throws NessieNotFoundException {
        return new ResultStreamPaginator<PaginatedResponse, ENTRY>(entriesExtractor, pageFetcher::getPage).generateStream();
    }

    @FunctionalInterface
    public static interface NextPage<R> {
        public R getPage(String var1) throws NessieNotFoundException;
    }
}

