/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.v1api;

import java.util.stream.Stream;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.CommitLogParamsBuilder;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.http.NessieApiClient;
import org.projectnessie.client.http.v1api.BaseHttpOnReferenceRequest;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.LogResponse;

final class HttpGetCommitLog
extends BaseHttpOnReferenceRequest<GetCommitLogBuilder>
implements GetCommitLogBuilder {
    private final CommitLogParamsBuilder params = CommitLogParams.builder();

    HttpGetCommitLog(NessieApiClient client) {
        super(client);
    }

    @Override
    public GetCommitLogBuilder fetch(FetchOption fetchOption) {
        this.params.fetchOption(fetchOption);
        return this;
    }

    @Override
    public GetCommitLogBuilder untilHash(String untilHash) {
        this.params.startHash(untilHash);
        return this;
    }

    @Override
    public GetCommitLogBuilder maxRecords(int maxRecords) {
        this.params.maxRecords(Integer.valueOf(maxRecords));
        return this;
    }

    @Override
    public GetCommitLogBuilder pageToken(String pageToken) {
        this.params.pageToken(pageToken);
        return this;
    }

    @Override
    public GetCommitLogBuilder filter(String filter) {
        this.params.filter(filter);
        return this;
    }

    private CommitLogParams params() {
        this.params.endHash(this.hashOnRef);
        return this.params.build();
    }

    @Override
    public LogResponse get() throws NessieNotFoundException {
        return this.get(this.params());
    }

    private LogResponse get(CommitLogParams p) throws NessieNotFoundException {
        return this.client.getTreeApi().getCommitLog(this.refName, p);
    }

    @Override
    public Stream<LogResponse.LogEntry> stream() throws NessieNotFoundException {
        CommitLogParams p = this.params();
        return StreamingUtil.generateStream(LogResponse::getLogEntries, pageToken -> this.get(p.forNextPage(pageToken)));
    }
}

