/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.net.httpserver.HttpHandler;
import io.opentracing.Scope;
import io.opentracing.util.GlobalTracer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.client.rest.NessieBadResponseException;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.client.util.JaegerTestTracer;
import org.projectnessie.client.util.TestHttpUtil;
import org.projectnessie.client.util.TestServer;
import org.projectnessie.model.Branch;

class TestNessieHttpClient {
    TestNessieHttpClient() {
    }

    @BeforeAll
    static void setupTracer() {
        JaegerTestTracer.register();
    }

    @Test
    void testNonJsonResponse() throws Exception {
        HttpHandler handler = h -> {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"GET", (Object)h.getRequestMethod());
            TestHttpUtil.writeResponseBody(h, "<html>hello world>", "text/html");
        };
        try (TestServer server = new TestServer(handler);){
            NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri()).withTracing(true).build(NessieApiV1.class);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((NessieApiV1)api).getDefaultBranch()).isInstanceOf(NessieBadResponseException.class)).hasMessageStartingWith("Expected the server to return a JSON compatible response, but the server returned with Content-Type 'text/html' from ");
        }
    }

    @ParameterizedTest
    @ValueSource(strings={"application/json", "application/json;charset=utf-8", "text/json", "mystuff/foo+json", "mystuff/foo+json;charset=utf-8"})
    void testValidJsonResponse(String contentType) throws Exception {
        HttpHandler handler = h -> {
            org.junit.jupiter.api.Assertions.assertEquals((Object)"GET", (Object)h.getRequestMethod());
            String response = new ObjectMapper().writeValueAsString((Object)Branch.of((String)"foo", (String)"deadbeef"));
            TestHttpUtil.writeResponseBody(h, response, contentType);
        };
        try (TestServer server = new TestServer("/trees/tree", handler);
             NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri()).withTracing(true).build(NessieApiV1.class);){
            api.getDefaultBranch();
        }
    }

    @Test
    void testTracing() throws Exception {
        AtomicReference<String> traceId = new AtomicReference<String>();
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Uber-trace-id", traceId));
             NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri()).withTracing(true).build(NessieApiV1.class);
             Scope ignore = GlobalTracer.get().activateSpan(GlobalTracer.get().buildSpan("testOpenTracing").start());){
            api.getConfig();
        }
        org.junit.jupiter.api.Assertions.assertNotNull((Object)traceId.get());
    }

    @Test
    void testTracingNotEnabled() throws Exception {
        AtomicReference<String> traceId = new AtomicReference<String>();
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Uber-trace-id", traceId));
             NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri()).withTracing(false).build(NessieApiV1.class);
             Scope ignore = GlobalTracer.get().activateSpan(GlobalTracer.get().buildSpan("testOpenTracing").start());){
            api.getConfig();
        }
        org.junit.jupiter.api.Assertions.assertNull((Object)traceId.get());
    }

    private TestServer errorServer(int status) throws IOException {
        return new TestServer(h -> {
            h.sendResponseHeaders(status, 0L);
            h.getResponseBody().close();
        });
    }

    @Test
    void testNotFoundOnBaseUri() throws IOException {
        try (TestServer server = this.errorServer(404);
             NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri().resolve("/unknownPath")).build(NessieApiV1.class);){
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((NessieApiV1)api).getConfig()).isInstanceOf(RuntimeException.class)).hasMessageContaining("Not Found");
        }
    }

    @Test
    void testInternalServerError() throws IOException {
        try (TestServer server = this.errorServer(500);
             NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri().resolve("/broken")).build(NessieApiV1.class);){
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((NessieApiV1)api).getConfig()).isInstanceOf(NessieInternalServerException.class)).hasMessageContaining("Internal Server Error");
        }
    }

    @Test
    void testUnauthorized() throws IOException {
        try (TestServer server = this.errorServer(401);
             NessieApiV1 api = (NessieApiV1)HttpClientBuilder.builder().withUri(server.getUri().resolve("/unauthorized")).build(NessieApiV1.class);){
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((NessieApiV1)api).getConfig()).isInstanceOf(NessieNotAuthorizedException.class)).hasMessageContaining("Unauthorized");
        }
    }

    static HttpHandler handlerForHeaderTest(String headerName, AtomicReference<String> receiver) {
        return h -> {
            receiver.set(h.getRequestHeaders().getFirst(headerName));
            h.getRequestBody().close();
            h.getResponseHeaders().add("Content-Type", "application/json");
            TestHttpUtil.writeResponseBody(h, "{\"maxSupportedApiVersion\":1}");
        };
    }
}

