/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.projectnessie.client.ResultStreamPaginator;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.PaginatedResponse;

@Execution(value=ExecutionMode.CONCURRENT)
class TestResultStreamPaginator {
    TestResultStreamPaginator() {
    }

    @Test
    void testNotFoundException() {
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, token -> {
            throw new NessieReferenceNotFoundException("Ref not found");
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ResultStreamPaginator)paginator).generateStream()).isInstanceOf(NessieReferenceNotFoundException.class)).hasMessage("Ref not found");
    }

    @Test
    void testNoPageSizeHint1Page() throws Exception {
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, token -> {
            org.junit.jupiter.api.Assertions.assertNull((Object)token);
            return new MockPaginatedResponse(false, null, Arrays.asList("1", "2", "3"));
        });
        Assertions.assertThat((Stream)paginator.generateStream()).containsExactly((Object[])new String[]{"1", "2", "3"});
    }

    @Test
    void testNoPageSizeHint2Pages() throws Exception {
        Iterator<String> expectedTokens = Arrays.asList(null, "token").iterator();
        Iterator<MockPaginatedResponse> responses = Arrays.asList(new MockPaginatedResponse(true, "token", Arrays.asList("1", "2", "3")), new MockPaginatedResponse(false, null, Arrays.asList("4", "5", "6"))).iterator();
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, token -> {
            org.junit.jupiter.api.Assertions.assertEquals(expectedTokens.next(), (Object)token);
            return (MockPaginatedResponse)responses.next();
        });
        Assertions.assertThat((Stream)paginator.generateStream()).containsExactly((Object[])new String[]{"1", "2", "3", "4", "5", "6"});
    }

    @Test
    void testPageSizeHint1Page() throws Exception {
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, token -> {
            org.junit.jupiter.api.Assertions.assertNull((Object)token);
            return new MockPaginatedResponse(false, null, Arrays.asList("1", "2", "3"));
        });
        Assertions.assertThat((Stream)paginator.generateStream()).containsExactly((Object[])new String[]{"1", "2", "3"});
    }

    @Test
    void testPageSizeHint2Pages() throws Exception {
        Iterator<String> expectedTokens = Arrays.asList(null, "token").iterator();
        Iterator<MockPaginatedResponse> responses = Arrays.asList(new MockPaginatedResponse(true, "token", Arrays.asList("1", "2", "3")), new MockPaginatedResponse(false, null, Arrays.asList("4", "5", "6"))).iterator();
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, token -> {
            org.junit.jupiter.api.Assertions.assertEquals(expectedTokens.next(), (Object)token);
            return (MockPaginatedResponse)responses.next();
        });
        Assertions.assertThat((Stream)paginator.generateStream()).containsExactly((Object[])new String[]{"1", "2", "3", "4", "5", "6"});
    }

    @Test
    void testEmptyResult() throws Exception {
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, token -> new MockPaginatedResponse(false, null, Collections.emptyList()));
        Assertions.assertThat((Stream)paginator.generateStream()).isEmpty();
    }

    @Test
    void testEmptyResultInPage() throws Exception {
        Iterator<String> expectedTokens = Arrays.asList(null, "token").iterator();
        Iterator<MockPaginatedResponse> responses = Arrays.asList(new MockPaginatedResponse(true, "token", Arrays.asList("1", "2", "3")), new MockPaginatedResponse(false, null, Collections.emptyList())).iterator();
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, token -> {
            org.junit.jupiter.api.Assertions.assertEquals(expectedTokens.next(), (Object)token);
            return (MockPaginatedResponse)responses.next();
        });
        Assertions.assertThat((Stream)paginator.generateStream()).containsExactly((Object[])new String[]{"1", "2", "3"});
    }

    @Test
    void testEmptyResultButMoreInPage() {
        Iterator<String> expectedTokens = Arrays.asList(null, "token").iterator();
        Iterator<MockPaginatedResponse> responses = Arrays.asList(new MockPaginatedResponse(true, "token", Arrays.asList("1", "2", "3")), new MockPaginatedResponse(true, "wtf", Collections.emptyList())).iterator();
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, token -> {
            org.junit.jupiter.api.Assertions.assertEquals(expectedTokens.next(), (Object)token);
            return (MockPaginatedResponse)responses.next();
        });
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> paginator.generateStream().collect(Collectors.toList())).isInstanceOf(IllegalStateException.class)).hasMessage("Backend returned empty page, but indicates there are more results");
    }

    private static class MockPaginatedResponse
    implements PaginatedResponse {
        private final boolean more;
        private final String token;
        private final List<String> elements;

        public MockPaginatedResponse(boolean more, String token, List<String> elements) {
            this.more = more;
            this.token = token;
            this.elements = elements;
        }

        List<String> getElements() {
            return this.elements;
        }

        public boolean isHasMore() {
            return this.more;
        }

        @Nullable
        public String getToken() {
            return this.token;
        }
    }
}

