/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;

class ResponseContextImpl
implements ResponseContext {
    private final HttpURLConnection connection;
    private final URI uri;

    ResponseContextImpl(HttpURLConnection connection, URI uri) {
        this.connection = connection;
        this.uri = uri;
    }

    @Override
    public Status getResponseCode() throws IOException {
        return Status.fromCode(this.connection.getResponseCode());
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.maybeDecompress(this.connection.getInputStream());
    }

    @Override
    public InputStream getErrorStream() throws IOException {
        return this.maybeDecompress(this.connection.getErrorStream());
    }

    @Override
    public boolean isJsonCompatibleResponse() {
        String contentType = this.getContentType();
        if (contentType == null) {
            return false;
        }
        int i = contentType.indexOf(59);
        if (i > 0) {
            contentType = contentType.substring(0, i);
        }
        return contentType.endsWith("/json") || contentType.endsWith("+json");
    }

    @Override
    public String getContentType() {
        return this.connection.getHeaderField("Content-Type");
    }

    @Override
    public URI getRequestedUri() {
        return this.uri;
    }

    private InputStream maybeDecompress(InputStream inputStream) throws IOException {
        String contentEncoding = this.connection.getHeaderField("Content-Encoding");
        if ("gzip".equals(contentEncoding)) {
            return new GZIPInputStream(inputStream);
        }
        if ("deflate".equals(contentEncoding)) {
            return new InflaterInputStream(inputStream);
        }
        return inputStream;
    }
}

