/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.v1api;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.projectnessie.api.params.NamespaceParams;
import org.projectnessie.api.params.NamespaceParamsBuilder;
import org.projectnessie.client.api.CreateNamespaceBuilder;
import org.projectnessie.client.http.NessieApiClient;
import org.projectnessie.client.http.v1api.BaseHttpRequest;
import org.projectnessie.error.NessieNamespaceAlreadyExistsException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.ImmutableNamespace;
import org.projectnessie.model.Namespace;

final class HttpCreateNamespace
extends BaseHttpRequest
implements CreateNamespaceBuilder {
    private final NamespaceParamsBuilder builder = NamespaceParams.builder();
    private final Map<String, String> properties = new HashMap<String, String>();

    HttpCreateNamespace(NessieApiClient client) {
        super(client);
    }

    @Override
    public CreateNamespaceBuilder namespace(Namespace namespace) {
        this.builder.namespace(namespace);
        return this;
    }

    @Override
    public CreateNamespaceBuilder refName(String refName) {
        this.builder.refName(refName);
        return this;
    }

    @Override
    public CreateNamespaceBuilder hashOnRef(@Nullable String hashOnRef) {
        this.builder.hashOnRef(hashOnRef);
        return this;
    }

    @Override
    public CreateNamespaceBuilder properties(Map<String, String> properties) {
        this.properties.putAll(properties);
        return this;
    }

    @Override
    public CreateNamespaceBuilder property(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    @Override
    public Namespace create() throws NessieNamespaceAlreadyExistsException, NessieReferenceNotFoundException {
        NamespaceParams params = this.builder.build();
        return this.client.getNamespaceApi().createNamespace(params, (Namespace)ImmutableNamespace.builder().from(params.getNamespace()).properties(this.properties).build());
    }
}

