/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http.v1api;

import java.util.stream.Stream;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.api.params.ReferencesParams;
import org.projectnessie.api.params.ReferencesParamsBuilder;
import org.projectnessie.client.StreamingUtil;
import org.projectnessie.client.api.GetAllReferencesBuilder;
import org.projectnessie.client.http.NessieApiClient;
import org.projectnessie.client.http.v1api.BaseHttpRequest;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;

final class HttpGetAllReferences
extends BaseHttpRequest
implements GetAllReferencesBuilder {
    private final ReferencesParamsBuilder params;

    HttpGetAllReferences(NessieApiClient client) {
        this(client, ReferencesParams.builder());
    }

    HttpGetAllReferences(NessieApiClient client, ReferencesParamsBuilder params) {
        super(client);
        this.params = params;
    }

    @Override
    public GetAllReferencesBuilder maxRecords(int maxRecords) {
        this.params.maxRecords(Integer.valueOf(maxRecords));
        return this;
    }

    @Override
    public GetAllReferencesBuilder pageToken(String pageToken) {
        this.params.pageToken(pageToken);
        return this;
    }

    @Override
    public GetAllReferencesBuilder fetch(FetchOption fetchOption) {
        this.params.fetchOption(fetchOption);
        return this;
    }

    @Override
    public GetAllReferencesBuilder filter(String filter) {
        this.params.filter(filter);
        return this;
    }

    private ReferencesParams params() {
        return this.params.build();
    }

    @Override
    public ReferencesResponse get() {
        return this.get(this.params());
    }

    private ReferencesResponse get(ReferencesParams p) {
        return this.client.getTreeApi().getAllReferences(p);
    }

    @Override
    public Stream<Reference> stream() throws NessieNotFoundException {
        ReferencesParams p = this.params();
        return StreamingUtil.generateStream(ReferencesResponse::getReferences, pageToken -> this.get(p.forNextPage(pageToken)));
    }
}

