/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.util.v2api;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.GetEntriesBuilder;
import org.projectnessie.client.api.NessieApiV2;
import org.projectnessie.client.builder.BaseGetMultipleNamespacesBuilder;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.GetNamespacesResponse;
import org.projectnessie.model.ImmutableGetNamespacesResponse;
import org.projectnessie.model.Namespace;

public final class ClientSideGetMultipleNamespaces
extends BaseGetMultipleNamespacesBuilder {
    private final NessieApiV2 api;

    public ClientSideGetMultipleNamespaces(NessieApiV2 api) {
        this.api = api;
    }

    @Override
    public GetNamespacesResponse get() throws NessieReferenceNotFoundException {
        Map<ContentKey, Content> contentMap;
        List<ContentKey> entries;
        try {
            GetEntriesBuilder getEntries = (GetEntriesBuilder)((GetEntriesBuilder)this.api.getEntries().refName(this.refName)).hashOnRef(this.hashOnRef);
            if (this.namespace != null) {
                getEntries.filter(String.format("entry.key.startsWith('%s')", ContentKey.of((List)this.namespace.getElements())));
            }
            entries = getEntries.stream().filter(e -> Content.Type.NAMESPACE.equals(e.getType())).map(EntriesResponse.Entry::getName).filter(name -> this.namespace == null || Namespace.of((List)name.getElements()).isSameOrSubElementOf(this.namespace)).collect(Collectors.toList());
        }
        catch (NessieNotFoundException e2) {
            throw new NessieReferenceNotFoundException(e2.getMessage(), (Throwable)e2);
        }
        if (entries.isEmpty()) {
            return ImmutableGetNamespacesResponse.builder().build();
        }
        try {
            GetContentBuilder getContent = (GetContentBuilder)((GetContentBuilder)this.api.getContent().refName(this.refName)).hashOnRef(this.hashOnRef);
            entries.forEach(getContent::key);
            contentMap = getContent.get();
        }
        catch (NessieNotFoundException e3) {
            throw new NessieReferenceNotFoundException(e3.getMessage(), (Throwable)e3);
        }
        ImmutableGetNamespacesResponse.Builder builder = ImmutableGetNamespacesResponse.builder();
        contentMap.values().stream().map(v -> v.unwrap(Namespace.class)).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((ImmutableGetNamespacesResponse.Builder)builder).addNamespaces(arg_0));
        return builder.build();
    }
}

