/*
 * Copyright (C) 2020 Dremio
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.projectnessie.client.rest;

import org.projectnessie.error.NessieError;

/**
 * Indicates a condition where the client's request was not authorized to access the Nessie Server.
 * Note that this exception generally results from error responses generated by service containers
 * above the level of Nessie services.
 *
 * <p>Authorization failures within Nessie will generally be represented by {@code
 * NessieForbiddenException}.
 */
public class NessieNotAuthorizedException extends NessieServiceException {

  public NessieNotAuthorizedException(NessieError serverError) {
    super(serverError);
  }
}
