/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import com.sun.net.httpserver.HttpHandler;
import io.jaegertracing.internal.JaegerTracer;
import io.opentracing.Scope;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import java.io.OutputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.util.TestServer;

class TestNessieHttpClient {
    TestNessieHttpClient() {
    }

    @BeforeAll
    static void setupTracer() {
        GlobalTracer.register((Tracer)new JaegerTracer.Builder("TestNessieHttpClient").build());
    }

    @Test
    void testNullUri() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> NessieClient.builder().withUri((URI)null).build());
    }

    @Test
    void testAuthBasic() throws Exception {
        AtomicReference<String> authHeader = new AtomicReference<String>();
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Authorization", authHeader));){
            NessieClient client = NessieClient.builder().withUri(server.getUri()).withAuthType(NessieClient.AuthType.BASIC).withUsername("my_username").withPassword("very_secret").build();
            client.getConfigApi().getConfig();
        }
        Assertions.assertEquals((Object)("Basic " + new String(Base64.getUrlEncoder().encode("my_username:very_secret".getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8)), (Object)authHeader.get());
    }

    @Test
    void testTracing() throws Exception {
        AtomicReference<String> traceId = new AtomicReference<String>();
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Uber-trace-id", traceId));){
            NessieClient client = NessieClient.builder().withUri(server.getUri()).withTracing(true).build();
            try (Scope ignore = GlobalTracer.get().buildSpan("testOpenTracing").startActive(true);){
                client.getConfigApi().getConfig();
            }
        }
        Assertions.assertNotNull((Object)traceId.get());
    }

    @Test
    void testTracingNotEnabled() throws Exception {
        AtomicReference<String> traceId = new AtomicReference<String>();
        try (TestServer server = new TestServer(TestNessieHttpClient.handlerForHeaderTest("Uber-trace-id", traceId));){
            NessieClient client = NessieClient.builder().withUri(server.getUri()).withTracing(false).build();
            try (Scope ignore = GlobalTracer.get().buildSpan("testOpenTracing").startActive(true);){
                client.getConfigApi().getConfig();
            }
        }
        Assertions.assertNull((Object)traceId.get());
    }

    static HttpHandler handlerForHeaderTest(String headerName, AtomicReference<String> receiver) {
        return h -> {
            receiver.set(h.getRequestHeaders().getFirst(headerName));
            h.getRequestBody().close();
            h.sendResponseHeaders(200, 2L);
            try (OutputStream out = h.getResponseBody();){
                out.write("{}".getBytes(StandardCharsets.UTF_8));
            }
        };
    }
}

