/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.ResultStreamPaginator;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.PaginatedResponse;

class TestResultStreamPaginator {
    TestResultStreamPaginator() {
    }

    @Test
    void testNotFoundException() {
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            throw new NessieNotFoundException("Ref not found");
        });
        Assertions.assertEquals((Object)"Ref not found", (Object)((NessieNotFoundException)Assertions.assertThrows(NessieNotFoundException.class, () -> paginator.generateStream("ref", OptionalInt.empty()))).getMessage());
    }

    @Test
    void testNoPageSizeHint1Page() throws Exception {
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            Assertions.assertNull((Object)pageSize);
            Assertions.assertNull((Object)token);
            return new MockPaginatedResponse(false, null, Arrays.asList("1", "2", "3"));
        });
        Assertions.assertEquals(Arrays.asList("1", "2", "3"), paginator.generateStream("ref", OptionalInt.empty()).collect(Collectors.toList()));
    }

    @Test
    void testNoPageSizeHint2Pages() throws Exception {
        Iterator<String> expectedTokens = Arrays.asList(null, "token").iterator();
        Iterator<MockPaginatedResponse> responses = Arrays.asList(new MockPaginatedResponse(true, "token", Arrays.asList("1", "2", "3")), new MockPaginatedResponse(false, null, Arrays.asList("4", "5", "6"))).iterator();
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            Assertions.assertNull((Object)pageSize);
            Assertions.assertEquals(expectedTokens.next(), (Object)token);
            return (MockPaginatedResponse)responses.next();
        });
        Assertions.assertEquals(Arrays.asList("1", "2", "3", "4", "5", "6"), paginator.generateStream("ref", OptionalInt.empty()).collect(Collectors.toList()));
    }

    @Test
    void testPageSizeHint1Page() throws Exception {
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            Assertions.assertEquals((int)5, (Integer)pageSize);
            Assertions.assertNull((Object)token);
            return new MockPaginatedResponse(false, null, Arrays.asList("1", "2", "3"));
        });
        Assertions.assertEquals(Arrays.asList("1", "2", "3"), paginator.generateStream("ref", OptionalInt.of(5)).collect(Collectors.toList()));
    }

    @Test
    void testPageSizeHint2Pages() throws Exception {
        Iterator<String> expectedTokens = Arrays.asList(null, "token").iterator();
        Iterator<MockPaginatedResponse> responses = Arrays.asList(new MockPaginatedResponse(true, "token", Arrays.asList("1", "2", "3")), new MockPaginatedResponse(false, null, Arrays.asList("4", "5", "6"))).iterator();
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            Assertions.assertEquals((int)5, (Integer)pageSize);
            Assertions.assertEquals(expectedTokens.next(), (Object)token);
            return (MockPaginatedResponse)responses.next();
        });
        Assertions.assertEquals(Arrays.asList("1", "2", "3", "4", "5", "6"), paginator.generateStream("ref", OptionalInt.of(5)).collect(Collectors.toList()));
    }

    @Test
    void testEmptyResult() throws Exception {
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> new MockPaginatedResponse(false, null, Collections.emptyList()));
        Assertions.assertEquals(Collections.emptyList(), paginator.generateStream("ref", OptionalInt.of(5)).collect(Collectors.toList()));
    }

    @Test
    void testEmptyResultInPage() throws Exception {
        Iterator<String> expectedTokens = Arrays.asList(null, "token").iterator();
        Iterator<MockPaginatedResponse> responses = Arrays.asList(new MockPaginatedResponse(true, "token", Arrays.asList("1", "2", "3")), new MockPaginatedResponse(false, null, Collections.emptyList())).iterator();
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            Assertions.assertEquals((int)5, (Integer)pageSize);
            Assertions.assertEquals(expectedTokens.next(), (Object)token);
            return (MockPaginatedResponse)responses.next();
        });
        Assertions.assertEquals(Arrays.asList("1", "2", "3"), paginator.generateStream("ref", OptionalInt.of(5)).collect(Collectors.toList()));
    }

    @Test
    void testEmptyResultButMoreInPage() {
        Iterator<String> expectedTokens = Arrays.asList(null, "token").iterator();
        Iterator<MockPaginatedResponse> responses = Arrays.asList(new MockPaginatedResponse(true, "token", Arrays.asList("1", "2", "3")), new MockPaginatedResponse(true, "wtf", Collections.emptyList())).iterator();
        ResultStreamPaginator paginator = new ResultStreamPaginator(MockPaginatedResponse::getElements, (ref, pageSize, token) -> {
            Assertions.assertEquals((int)5, (Integer)pageSize);
            Assertions.assertEquals(expectedTokens.next(), (Object)token);
            return (MockPaginatedResponse)responses.next();
        });
        Assertions.assertThrows(IllegalStateException.class, () -> paginator.generateStream("ref", OptionalInt.of(5)).collect(Collectors.toList()));
    }

    private static class MockPaginatedResponse
    implements PaginatedResponse {
        private final boolean more;
        private final String token;
        private final List<String> elements;

        public MockPaginatedResponse(boolean more, String token, List<String> elements) {
            this.more = more;
            this.token = token;
            this.elements = elements;
        }

        List<String> getElements() {
            return this.elements;
        }

        public boolean hasMore() {
            return this.more;
        }

        @Nullable
        public String getToken() {
            return this.token;
        }
    }
}

