/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client;

import java.util.List;
import java.util.OptionalInt;
import java.util.stream.Stream;
import javax.validation.constraints.NotNull;
import org.projectnessie.api.TreeApi;
import org.projectnessie.client.ResultStreamPaginator;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;

public final class StreamingUtil {
    private StreamingUtil() {
    }

    public static Stream<EntriesResponse.Entry> getEntriesStream(@NotNull TreeApi treeApi, @NotNull String ref, OptionalInt pageSizeHint, List<String> types) throws NessieNotFoundException {
        return new ResultStreamPaginator(EntriesResponse::getEntries, (ref1, pageSize, token) -> treeApi.getEntries(ref1, pageSize, token, types)).generateStream(ref, pageSizeHint);
    }

    public static Stream<CommitMeta> getCommitLogStream(@NotNull TreeApi treeApi, @NotNull String ref, OptionalInt pageSizeHint) throws NessieNotFoundException {
        return new ResultStreamPaginator(LogResponse::getOperations, (arg_0, arg_1, arg_2) -> ((TreeApi)treeApi).getCommitLog(arg_0, arg_1, arg_2)).generateStream(ref, pageSizeHint);
    }
}

