/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.rest.NessieBadRequestException;
import org.projectnessie.client.rest.NessieForbiddenException;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.client.rest.NessieServiceException;
import org.projectnessie.client.rest.ResponseCheckFilter;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.NessieNotFoundException;
import software.amazon.awssdk.utils.StringInputStream;

public class TestResponseFilter {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @ParameterizedTest
    @MethodSource(value={"provider"})
    void testResponseFilter(Status responseCode, Class<? extends Exception> clazz) {
        block3: {
            NessieError error = new NessieError(responseCode.getCode(), responseCode.getReason(), "xxx", null);
            try {
                ResponseCheckFilter.checkResponse((ResponseContext)new TestResponseContext(responseCode, error), (ObjectMapper)MAPPER);
            }
            catch (Exception e) {
                Assertions.assertThat((Throwable)e).isInstanceOf(clazz);
                if (e instanceof NessieServiceException) {
                    Assertions.assertThat((Object)((NessieServiceException)e).getError()).isEqualTo((Object)error);
                }
                if (!(e instanceof BaseNessieClientServerException)) break block3;
                Assertions.assertThat((int)((BaseNessieClientServerException)e).getStatus()).isEqualTo(error.getStatus());
                Assertions.assertThat((String)((BaseNessieClientServerException)e).getServerStackTrace()).isEqualTo(error.getServerStackTrace());
            }
        }
    }

    @Test
    void testBadReturn() {
        NessieError error = new NessieError("unknown", 415, "xxx", null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ResponseCheckFilter.checkResponse((ResponseContext)new TestResponseContext(Status.UNSUPPORTED_MEDIA_TYPE, error), (ObjectMapper)MAPPER)).isInstanceOf(NessieServiceException.class)).hasMessage("xxx (HTTP/415): unknown");
    }

    @Test
    void testBadReturnNoError() throws IOException {
        try {
            ResponseCheckFilter.checkResponse((ResponseContext)new ResponseContext(){

                public Status getResponseCode() {
                    return Status.UNAUTHORIZED;
                }

                public InputStream getInputStream() {
                    org.junit.jupiter.api.Assertions.fail();
                    return null;
                }

                public InputStream getErrorStream() {
                    return new StringInputStream("this will fail");
                }
            }, (ObjectMapper)MAPPER);
        }
        catch (NessieServiceException e) {
            Assertions.assertThat((int)Status.UNAUTHORIZED.getCode()).isEqualTo(e.getError().getStatus());
            Assertions.assertThat((Throwable)e.getError().getClientProcessingException()).isInstanceOf(IOException.class);
            Assertions.assertThat((String)e.getError().getServerStackTrace()).isNull();
        }
    }

    @Test
    void testBadReturnBadError() {
        NessieError defaultError = new NessieError(Status.UNAUTHORIZED.getCode(), Status.UNAUTHORIZED.getReason(), "Could not parse error object in response.", (Exception)new RuntimeException("Could not parse error object in response."));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ResponseCheckFilter.checkResponse((ResponseContext)new TestResponseContext(Status.UNAUTHORIZED, null), (ObjectMapper)MAPPER)).isInstanceOf(NessieServiceException.class)).extracting("error").isEqualTo((Object)defaultError);
    }

    @Test
    void testGood() {
        org.junit.jupiter.api.Assertions.assertDoesNotThrow(() -> ResponseCheckFilter.checkResponse((ResponseContext)new TestResponseContext(Status.OK, null), (ObjectMapper)MAPPER));
    }

    private static Stream<Arguments> provider() {
        return Stream.of(Arguments.of((Object[])new Object[]{Status.BAD_REQUEST, NessieBadRequestException.class}), Arguments.of((Object[])new Object[]{Status.UNAUTHORIZED, NessieNotAuthorizedException.class}), Arguments.of((Object[])new Object[]{Status.FORBIDDEN, NessieForbiddenException.class}), Arguments.of((Object[])new Object[]{Status.NOT_FOUND, NessieNotFoundException.class}), Arguments.of((Object[])new Object[]{Status.CONFLICT, NessieConflictException.class}), Arguments.of((Object[])new Object[]{Status.INTERNAL_SERVER_ERROR, NessieInternalServerException.class}));
    }

    private static class TestResponseContext
    implements ResponseContext {
        private final Status code;
        private final NessieError error;

        TestResponseContext(Status code, NessieError error) {
            this.code = code;
            this.error = error;
        }

        public Status getResponseCode() {
            return this.code;
        }

        public InputStream getInputStream() {
            org.junit.jupiter.api.Assertions.fail();
            return null;
        }

        public InputStream getErrorStream() throws IOException {
            if (this.error == null) {
                return null;
            }
            String value = MAPPER.writeValueAsString((Object)this.error);
            return new StringInputStream(value);
        }
    }
}

