/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth;

import com.google.common.collect.ImmutableMap;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.projectnessie.client.auth.AwsAuthenticationProvider;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.auth.NessieAuthenticationProvider;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.RequestContext;
import org.projectnessie.client.http.RequestFilter;
import software.amazon.awssdk.core.SdkSystemSetting;
import software.amazon.awssdk.regions.Region;

class TestAwsAuthProvider {
    TestAwsAuthProvider() {
    }

    @Test
    void testAws() {
        ImmutableMap authCfg = ImmutableMap.of((Object)"nessie.auth-type", (Object)"AWS", (Object)"nessie.aws.region", (Object)"eu-central-1");
        ((ObjectAssert)Assertions.assertThat((Object)NessieAuthenticationProvider.fromConfig(((Map)authCfg)::get)).isNotNull()).extracting(Object::getClass).extracting(Class::getSimpleName).isEqualTo((Object)"AwsAuthentication");
        authCfg = ImmutableMap.of((Object)"nessie.auth-type", (Object)"AWS");
        ((ObjectAssert)Assertions.assertThat((Object)NessieAuthenticationProvider.fromConfig(((Map)authCfg)::get)).isNotNull()).extracting(Object::getClass).extracting(Class::getSimpleName).isEqualTo((Object)"AwsAuthentication");
        ImmutableMap authCfgErr = ImmutableMap.of((Object)"nessie.auth-type", (Object)"AWS", (Object)"nessie.aws.region", (Object)"not-on-this-planet-1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> NessieAuthenticationProvider.fromConfig(arg_0 -> ((ImmutableMap)authCfgErr).get(arg_0))).isInstanceOf(IllegalArgumentException.class)).hasMessage("Unknown region 'not-on-this-planet-1'.");
    }

    @Test
    void testFromConfig() {
        ImmutableMap authCfg = ImmutableMap.of((Object)"nessie.auth-type", (Object)"AWS");
        NessieAuthentication authentication = NessieAuthenticationProvider.fromConfig(((Map)authCfg)::get);
        this.checkAuth(authentication, Region.US_WEST_2.toString());
    }

    @Test
    void testStaticBuilder() {
        this.checkAuth((NessieAuthentication)AwsAuthenticationProvider.create((Region)Region.AWS_GLOBAL), Region.AWS_GLOBAL.toString());
    }

    void checkAuth(NessieAuthentication authentication, String expectedRegion) {
        Assertions.assertThat((Object)authentication).isInstanceOf(HttpAuthentication.class);
        HttpAuthentication httpAuthentication = (HttpAuthentication)authentication;
        RequestFilter[] authFilter = new RequestFilter[1];
        HttpClient client = (HttpClient)Mockito.mock(HttpClient.class);
        ((HttpClient)Mockito.doAnswer(invocationOnMock -> {
            Object[] args = invocationOnMock.getArguments();
            if (args.length == 1 && args[0] instanceof RequestFilter && args[0].getClass().getSimpleName().equalsIgnoreCase("AwsHttpAuthenticationFilter")) {
                authFilter[0] = (RequestFilter)args[0];
            }
            return null;
        }).when((Object)client)).register((RequestFilter)Mockito.any());
        httpAuthentication.applyToHttpClient(client);
        System.setProperty(SdkSystemSetting.AWS_ACCESS_KEY_ID.property(), "xxx");
        System.setProperty(SdkSystemSetting.AWS_SECRET_ACCESS_KEY.property(), "xxx");
        Assertions.assertThat((Object)authFilter[0]).isInstanceOf(RequestFilter.class);
        HashMap map = new HashMap();
        RequestContext context = new RequestContext(map, URI.create("http://localhost/"), HttpClient.Method.GET, null);
        authFilter[0].filter(context);
        ((AbstractStringAssert)((AbstractStringAssert)((AbstractStringAssert)((IterableAssert)((MapAssert)((MapAssert)Assertions.assertThat(map).containsKey((Object)"Authorization")).containsKey((Object)"X-Amz-Date")).extracting("Authorization", InstanceOfAssertFactories.iterable(String.class))).first(InstanceOfAssertFactories.STRING)).containsSequence(new CharSequence[]{expectedRegion})).containsSequence(new CharSequence[]{"Signature="})).containsSequence(new CharSequence[]{"Credential="});
    }
}

