/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Function;
import org.projectnessie.client.auth.NessieAuthenticationProvider;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.HttpClient;

public class BasicAuthenticationProvider
implements NessieAuthenticationProvider {
    public static final String AUTH_TYPE_VALUE = "BASIC";

    public static HttpAuthentication create(String username, String password) {
        return new BasicAuthentication(username, password);
    }

    @Override
    public String getAuthTypeValue() {
        return AUTH_TYPE_VALUE;
    }

    @Override
    public HttpAuthentication build(Function<String, String> configSupplier) {
        String username = configSupplier.apply("nessie.username");
        String password = configSupplier.apply("nessie.password");
        return new BasicAuthentication(username, password);
    }

    private static class BasicAuthentication
    implements HttpAuthentication {
        private final String username;
        private final String password;

        private BasicAuthentication(String username, String password) {
            if (username == null || password == null) {
                throw new NullPointerException("username and password parameters must be present for auth type BASIC");
            }
            this.username = username;
            this.password = password;
        }

        @Override
        public void applyToHttpClient(HttpClient client) {
            String userPass = this.username + ':' + this.password;
            byte[] encoded = Base64.getEncoder().encode(userPass.getBytes(StandardCharsets.UTF_8));
            String encodedString = new String(encoded, StandardCharsets.UTF_8);
            String authHeaderValue = "Basic " + encodedString;
            client.register(ctx -> ctx.putHeader("Authorization", authHeaderValue));
        }
    }
}

