/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.auth;

import java.util.Locale;
import java.util.ServiceLoader;
import java.util.function.Function;
import org.projectnessie.client.auth.NessieAuthentication;

public interface NessieAuthenticationProvider {
    public static NessieAuthentication fromConfig(Function<String, String> configuration) {
        String authType = configuration.apply("nessie.auth-type");
        if (authType != null) {
            NessieAuthenticationProvider ap2;
            for (NessieAuthenticationProvider ap2 : ServiceLoader.load(NessieAuthenticationProvider.class)) {
                if (!ap2.getAuthTypeValue().equalsIgnoreCase(authType)) continue;
                return ap2.build(configuration);
            }
            String reflectionClassName = NessieAuthentication.class.getName();
            reflectionClassName = reflectionClassName.substring(0, reflectionClassName.lastIndexOf(46) + 1) + authType.substring(0, 1).toUpperCase(Locale.ROOT) + authType.substring(1).toLowerCase(Locale.ROOT) + "AuthenticationProvider";
            ap2 = null;
            try {
                Class<?> provider = Class.forName(reflectionClassName);
                ap2 = (NessieAuthenticationProvider)provider.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ap2 != null) {
                return ap2.build(configuration);
            }
            throw new IllegalArgumentException(String.format("No authentication provider for '%s' found.", authType));
        }
        return null;
    }

    public String getAuthTypeValue();

    public NessieAuthentication build(Function<String, String> var1);
}

