/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.net.URI;
import java.util.function.Function;
import org.projectnessie.client.NessieClient;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.auth.NessieAuthentication;
import org.projectnessie.client.auth.NessieAuthenticationProvider;
import org.projectnessie.client.http.HttpAuthentication;
import org.projectnessie.client.http.NessieHttpClient;

public class HttpClientBuilder
implements NessieClientBuilder<HttpClientBuilder> {
    private URI uri;
    private HttpAuthentication authentication;
    private boolean tracing;
    private int readTimeoutMillis = Integer.parseInt(System.getProperty("sun.net.client.defaultReadTimeout", "25000"));
    private int connectionTimeoutMillis = Integer.parseInt(System.getProperty("sun.net.client.defaultConnectionTimeout", "5000"));

    protected HttpClientBuilder() {
    }

    public static HttpClientBuilder builder() {
        return new HttpClientBuilder();
    }

    @Override
    public HttpClientBuilder fromSystemProperties() {
        return this.fromConfig(System::getProperty);
    }

    @Override
    public HttpClientBuilder fromConfig(Function<String, String> configuration) {
        String uri = configuration.apply("nessie.uri");
        if (uri == null) {
            uri = configuration.apply("nessie.url");
        }
        if (uri != null) {
            this.uri = URI.create(uri);
        }
        this.withAuthenticationFromConfig((Function)configuration);
        String tracing = configuration.apply("nessie.tracing");
        if (tracing != null) {
            this.tracing = Boolean.parseBoolean(tracing);
        }
        return this;
    }

    @Override
    public HttpClientBuilder withAuthenticationFromConfig(Function<String, String> configuration) {
        this.withAuthentication(NessieAuthenticationProvider.fromConfig(configuration));
        return this;
    }

    @Override
    public HttpClientBuilder withUri(URI uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public HttpClientBuilder withUri(String uri) {
        return this.withUri(URI.create(uri));
    }

    @Override
    public HttpClientBuilder withAuthentication(NessieAuthentication authentication) {
        if (authentication != null && !(authentication instanceof HttpAuthentication)) {
            throw new IllegalArgumentException("HttpClientBuilder only accepts instances of HttpAuthentication");
        }
        this.authentication = (HttpAuthentication)authentication;
        return this;
    }

    public HttpClientBuilder withTracing(boolean tracing) {
        this.tracing = tracing;
        return this;
    }

    public HttpClientBuilder withReadTimeout(int readTimeoutMillis) {
        this.readTimeoutMillis = readTimeoutMillis;
        return this;
    }

    public HttpClientBuilder withConnectionTimeout(int connectionTimeoutMillis) {
        this.connectionTimeoutMillis = connectionTimeoutMillis;
        return this;
    }

    @Override
    public NessieClient build() {
        return new NessieHttpClient(this.uri, this.authentication, this.tracing, this.readTimeoutMillis, this.connectionTimeoutMillis);
    }
}

