/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import javax.validation.constraints.NotNull;
import org.projectnessie.api.ContentsApi;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Contents;
import org.projectnessie.model.ContentsKey;
import org.projectnessie.model.MultiGetContentsRequest;
import org.projectnessie.model.MultiGetContentsResponse;

class HttpContentsClient
implements ContentsApi {
    private final HttpClient client;

    public HttpContentsClient(HttpClient client) {
        this.client = client;
    }

    public Contents getContents(@NotNull ContentsKey key, String ref, String hashOnRef) throws NessieNotFoundException {
        return this.client.newRequest().path("contents").path(key.toPathString()).queryParam("ref", ref).queryParam("hashOnRef", hashOnRef).get().readEntity(Contents.class);
    }

    public MultiGetContentsResponse getMultipleContents(@NotNull String ref, String hashOnRef, @NotNull MultiGetContentsRequest request) throws NessieNotFoundException {
        return this.client.newRequest().path("contents").queryParam("ref", ref).queryParam("hashOnRef", hashOnRef).post(request).readEntity(MultiGetContentsResponse.class);
    }
}

