/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.util;

import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.function.Consumer;

public class TestServer
implements AutoCloseable {
    private final HttpServer server;

    public TestServer(String context, HttpHandler handler) throws IOException {
        this(context, handler, null);
    }

    public TestServer(String context, HttpHandler handler, Consumer<HttpsServer> init) throws IOException {
        HttpHandler safeHandler = exchange -> {
            try {
                handler.handle(exchange);
            }
            catch (Error | RuntimeException e) {
                exchange.sendResponseHeaders(503, 0L);
                throw e;
            }
        };
        if (init == null) {
            this.server = HttpServer.create(new InetSocketAddress("localhost", 0), 0);
        } else {
            this.server = HttpsServer.create(new InetSocketAddress("localhost", 0), 0);
            init.accept((HttpsServer)this.server);
        }
        this.server.createContext(context, safeHandler);
        this.server.setExecutor(null);
        this.server.start();
    }

    public TestServer(HttpHandler handler) throws IOException {
        this("/", handler);
    }

    public InetSocketAddress getAddress() {
        return this.server.getAddress();
    }

    public URI getUri() {
        return URI.create("http://" + this.getAddress().getAddress().getHostAddress() + ":" + this.getAddress().getPort() + "/");
    }

    @Override
    public void close() {
        this.server.stop(0);
    }
}

