/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Objects;
import java.util.StringJoiner;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.projectnessie.api.params.AbstractParams;

public class ReferencesParams
extends AbstractParams {
    @Parameter(description="If set to true, will fetch additional metadata for references.\n\nA returned Branch instance will have the following information:\n\n- numCommitsAhead (number of commits ahead of the default branch)\n\n- numCommitsBehind (number of commits behind the default branch)\n\n- commitMetaOfHEAD (the commit metadata of the HEAD commit)\n\n- commonAncestorHash (the hash of the common ancestor in relation to the default branch).\n\n- numTotalCommits (the total number of commits in this reference).\n\nA returned Tag instance will only contain the 'commitMetaOfHEAD' and 'numTotalCommits' fields.\n\nNote that computing & fetching additional metadata might be computationally expensive on the server-side, so this flag should be used with care.")
    @QueryParam(value="fetchAdditionalInfo")
    private boolean fetchAdditionalInfo;

    public ReferencesParams() {
    }

    private ReferencesParams(Integer maxRecords, String pageToken, boolean fetchAdditionalInfo) {
        super(maxRecords, pageToken);
        this.fetchAdditionalInfo = fetchAdditionalInfo;
    }

    private ReferencesParams(Builder builder) {
        this(builder.maxRecords, builder.pageToken, builder.fetchAdditionalInfo);
    }

    public boolean isFetchAdditionalInfo() {
        return this.fetchAdditionalInfo;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReferencesParams empty() {
        return new Builder().build();
    }

    public String toString() {
        return new StringJoiner(", ", ReferencesParams.class.getSimpleName() + "[", "]").add("maxRecords=" + this.maxRecords()).add("pageToken='" + this.pageToken() + "'").add("fetchAdditionalInfo=" + this.fetchAdditionalInfo).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferencesParams that = (ReferencesParams)o;
        return Objects.equals(this.maxRecords(), that.maxRecords()) && Objects.equals(this.pageToken(), that.pageToken()) && Objects.equals(this.fetchAdditionalInfo, that.fetchAdditionalInfo);
    }

    public int hashCode() {
        return Objects.hash(this.maxRecords(), this.pageToken(), this.fetchAdditionalInfo);
    }

    public static class Builder
    extends AbstractParams.Builder<Builder> {
        private boolean fetchAdditionalInfo = false;

        private Builder() {
        }

        public Builder from(ReferencesParams params) {
            return ((Builder)((Builder)this.maxRecords(params.maxRecords())).pageToken(params.pageToken())).fetchAdditionalInfo(params.fetchAdditionalInfo);
        }

        public Builder fetchAdditionalInfo(boolean fetchAdditionalInfo) {
            this.fetchAdditionalInfo = fetchAdditionalInfo;
            return this;
        }

        private void validate() {
        }

        public ReferencesParams build() {
            this.validate();
            return new ReferencesParams(this);
        }
    }
}

