/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.cli;

import com.google.common.annotations.VisibleForTesting;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.tools.contentgenerator.cli.GenerateContent;
import org.projectnessie.tools.contentgenerator.cli.NessieVersionProvider;
import picocli.CommandLine;

@CommandLine.Command(name="nessie-content-generator", mixinStandardHelpOptions=true, versionProvider=NessieVersionProvider.class, subcommands={GenerateContent.class, CommandLine.HelpCommand.class})
public class NessieContentGenerator {
    public static void main(String[] arguments) {
        System.exit(NessieContentGenerator.runMain(arguments));
    }

    @VisibleForTesting
    public static int runMain(String[] arguments) {
        return new CommandLine(new NessieContentGenerator()).setExecutionExceptionHandler((ex, cmd, parseResult) -> {
            if (ex instanceof BaseNessieClientServerException || ex instanceof HttpClientException) {
                cmd.getErr().println(cmd.getColorScheme().errorText(ex.toString()));
            } else {
                cmd.getErr().println(cmd.getColorScheme().richStackTraceString(ex));
            }
            return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode(ex) : cmd.getCommandSpec().exitCodeOnExecutionException();
        }).execute(arguments);
    }
}

