/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Objects;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.PathParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;

public class DiffParams {
    @NotNull
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..")
    @Parameter(description="The 'from' reference to start the diff from", examples={@ExampleObject(ref="ref")})
    @PathParam(value="fromRef")
    private @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String fromRef;
    @NotNull
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..")
    @Parameter(description="The 'to' reference to end the diff at.", examples={@ExampleObject(ref="ref")})
    @PathParam(value="toRef")
    private @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?$", message="Reference name must start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain ..") String toRef;

    public DiffParams() {
    }

    private DiffParams(String fromRef, String toRef) {
        this.fromRef = fromRef;
        this.toRef = toRef;
    }

    private DiffParams(Builder builder) {
        this(builder.fromRef, builder.toRef);
    }

    public String getFromRef() {
        return this.fromRef;
    }

    public String getToRef() {
        return this.toRef;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DiffParams that = (DiffParams)o;
        return Objects.equals(this.fromRef, that.fromRef) && Objects.equals(this.toRef, that.toRef);
    }

    public int hashCode() {
        return Objects.hash(this.fromRef, this.toRef);
    }

    public static class Builder {
        private String fromRef;
        private String toRef;

        public Builder from(DiffParams params) {
            return this.fromRef(params.fromRef).toRef(params.toRef);
        }

        public Builder fromRef(String fromRef) {
            this.fromRef = fromRef;
            return this;
        }

        public Builder toRef(String toRef) {
            this.toRef = toRef;
            return this;
        }

        private void validate() {
            Objects.requireNonNull(this.fromRef, "fromRef must be non-null");
            Objects.requireNonNull(this.toRef, "toRef must be non-null");
        }

        public DiffParams build() {
            this.validate();
            return new DiffParams(this);
        }
    }
}

