/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.cli;

import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.validation.constraints.Min;
import org.projectnessie.client.api.CommitMultipleOperationsBuilder;
import org.projectnessie.client.api.GetContentBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.NessieReferenceNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.IcebergTable;
import org.projectnessie.model.ImmutableDeltaLakeTable;
import org.projectnessie.model.ImmutableIcebergTable;
import org.projectnessie.model.ImmutableSqlView;
import org.projectnessie.model.Operation;
import org.projectnessie.model.SqlView;
import org.projectnessie.model.Tag;
import org.projectnessie.tools.contentgenerator.cli.AbstractCommand;
import picocli.CommandLine;

@CommandLine.Command(name="generate", mixinStandardHelpOptions=true, description={"Generate commits"})
public class GenerateContent
extends AbstractCommand {
    @CommandLine.Option(names={"-b", "--num-branches"}, defaultValue="1", description={"Number of branches to use."})
    private int branchCount;
    @CommandLine.Option(names={"-T", "--tag-probability"}, defaultValue="0", description={"Probability to create a new tag off the last commit."})
    private double newTagProbability;
    @CommandLine.Option(names={"-D", "--default-branch"}, description={"Name of the default branch, uses the server's default branch if not specified."})
    private String defaultBranchName;
    @Min(value=1L, message="Must create at least one commit.")
    @CommandLine.Option(names={"-n", "--num-commits"}, required=true, defaultValue="100", description={"Number of commits to create."})
    private @Min(value=1L, message="Must create at least one commit.") int numCommits;
    @CommandLine.Option(names={"-d", "--duration"}, description={"Runtime duration, equally distributed among the number of commits to create. See java.time.Duration for argument format details."})
    private Duration runtimeDuration;
    @Min(value=1L, message="Must use at least one table (content-key).")
    @CommandLine.Option(names={"-t", "--num-tables"}, defaultValue="1", description={"Number of table names, each commit chooses a random table (content-key)."})
    private @Min(value=1L, message="Must use at least one table (content-key).") int numTables;
    @CommandLine.Option(names={"--type"}, defaultValue="ICEBERG_TABLE", description={"Content-types to generate. Defaults to ICEBERG_TABLE. Possible values: ICEBERG_TABLE, DELTA_LAKE_TABLE, VIEW"})
    private Content.Type contentType;
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    @Override
    public void execute() throws BaseNessieClientServerException {
        Branch defaultBranch;
        NessieApiV1 api = this.createNessieApiInstance();
        if (this.runtimeDuration != null && (this.runtimeDuration.isZero() || this.runtimeDuration.isNegative())) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Duration must be absent to greater than zero.");
        }
        Duration perCommitDuration = Optional.ofNullable(this.runtimeDuration).orElse(Duration.ZERO).dividedBy(this.numCommits);
        ThreadLocalRandom random = ThreadLocalRandom.current();
        String runStartTime = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss").format(LocalDateTime.now());
        List tableNames = IntStream.range(0, this.numTables).mapToObj(i -> ContentKey.of(String.format("create-contents-%s", runStartTime), "contents", Integer.toString(i))).collect(Collectors.toList());
        if (this.defaultBranchName == null) {
            defaultBranch = api.getDefaultBranch();
        } else {
            try {
                defaultBranch = (Branch)api.getReference().refName(this.defaultBranchName).get();
            }
            catch (NessieReferenceNotFoundException e) {
                defaultBranch = api.getDefaultBranch();
                defaultBranch = (Branch)api.createReference().reference(Branch.of(this.defaultBranchName, defaultBranch.getHash())).sourceRefName(defaultBranch.getName()).create();
            }
        }
        ArrayList<String> branches = new ArrayList<String>();
        branches.add(defaultBranch.getName());
        while (branches.size() < this.branchCount) {
            String newBranchName = "branch-" + runStartTime + "_" + (branches.size() - 1);
            Branch branch = Branch.of(newBranchName, defaultBranch.getHash());
            this.spec.commandLine().getOut().printf("Creating branch '%s' from '%s' at %s%n", branch.getName(), defaultBranch.getName(), branch.getHash());
            api.createReference().reference(branch).sourceRefName(defaultBranch.getName()).create();
            branches.add(newBranchName);
        }
        this.spec.commandLine().getOut().printf("Starting contents generation, %d commits...%n", this.numCommits);
        for (int i2 = 0; i2 < this.numCommits; ++i2) {
            String branchName = (String)branches.get(random.nextInt(branches.size()));
            Branch commitToBranch = (Branch)api.getReference().refName(branchName).get();
            ContentKey tableName = (ContentKey)tableNames.get(random.nextInt(tableNames.size()));
            Content tableContents = ((GetContentBuilder)api.getContent().refName(branchName)).key(tableName).get().get(tableName);
            Content newContents = this.createContents(tableContents, random);
            this.spec.commandLine().getOut().printf("Committing content-key '%s' to branch '%s' at %s%n", tableName, commitToBranch.getName(), commitToBranch.getHash());
            CommitMultipleOperationsBuilder commit = ((CommitMultipleOperationsBuilder)api.commitMultipleOperations().branch(commitToBranch)).commitMeta(CommitMeta.builder().message(String.format("%s table %s on %s, commit #%d of %d", tableContents != null ? "Update" : "Create", tableName, branchName, i2, this.numCommits)).author(System.getProperty("user.name")).authorTime(Instant.now()).build());
            if (newContents instanceof IcebergTable) {
                commit.operation(Operation.Put.of(tableName, newContents, tableContents));
            } else {
                commit.operation(Operation.Put.of(tableName, newContents));
            }
            Branch newHead = commit.commit();
            if (random.nextDouble() < this.newTagProbability) {
                Tag tag = Tag.of("new-tag-" + random.nextLong(), newHead.getHash());
                this.spec.commandLine().getOut().printf("Creating tag '%s' from '%s' at %s%n", tag.getName(), branchName, tag.getHash());
                api.createReference().reference(tag).sourceRefName(branchName).create();
            }
            try {
                TimeUnit.NANOSECONDS.sleep(perCommitDuration.toNanos());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        this.spec.commandLine().getOut().printf("Done creating contents.%n", new Object[0]);
    }

    private Content createContents(Content currentContents, ThreadLocalRandom random) {
        switch (this.contentType) {
            case ICEBERG_TABLE: {
                ImmutableIcebergTable.Builder icebergBuilder = ImmutableIcebergTable.builder().snapshotId(random.nextLong()).schemaId(random.nextInt()).specId(random.nextInt()).sortOrderId(random.nextInt()).metadataLocation("metadata " + random.nextLong());
                if (currentContents != null) {
                    icebergBuilder.id(currentContents.getId());
                }
                return icebergBuilder.build();
            }
            case DELTA_LAKE_TABLE: {
                ImmutableDeltaLakeTable.Builder deltaBuilder = ImmutableDeltaLakeTable.builder().lastCheckpoint("Last checkpoint foo bar " + random.nextLong()).addMetadataLocationHistory("metadata location history " + random.nextLong());
                for (int i = 0; i < random.nextInt(4); ++i) {
                    deltaBuilder.lastCheckpoint("Another checkpoint " + random.nextLong()).addMetadataLocationHistory("Another metadata location " + random.nextLong());
                }
                if (currentContents != null) {
                    deltaBuilder.id(currentContents.getId());
                }
                return deltaBuilder.build();
            }
            case VIEW: {
                ImmutableSqlView.Builder viewBuilder = ImmutableSqlView.builder().dialect(SqlView.Dialect.values()[random.nextInt(SqlView.Dialect.values().length)]).sqlText("SELECT blah FROM meh;");
                if (currentContents != null) {
                    viewBuilder.id(currentContents.getId());
                }
                return viewBuilder.build();
            }
        }
        throw new UnsupportedOperationException(String.format("Content type %s not supported", this.contentType.name()));
    }
}

