/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.validation.constraints.Pattern;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.projectnessie.api.params.AbstractParams;

public class CommitLogParams
extends AbstractParams {
    @Nullable
    @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes")
    @Parameter(description="Hash on the given ref to start from (in chronological sense), the 'far' end of the commit log, returned 'late' in the result.", examples={@ExampleObject(ref="nullHash"), @ExampleObject(ref="hash")})
    @QueryParam(value="startHash")
    private @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String startHash;
    @Nullable
    @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes")
    @Parameter(description="Hash on the given ref to end at (in chronological sense), the 'near' end of the commit log, returned 'early' in the result.", examples={@ExampleObject(ref="nullHash"), @ExampleObject(ref="hash")})
    @QueryParam(value="endHash")
    private @Pattern(regexp="^[0-9a-fA-F]{16,64}$", message="Hash must consist of the hex representation of 8-32 bytes") String endHash;
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\n\nUsable variables within the expression are:\n\n- 'commit' with fields 'author' (string), 'committer' (string), 'commitTime' (timestamp), 'hash' (string), ',message' (string), 'properties' (map)\n\n- 'operations' (list), each operation has the fields 'type' (string, either 'PUT' or 'DELETE'), 'key' (string, namespace + table name), 'keyElements' (list of strings), 'namespace' (string), 'namespaceElements' (list of strings) and 'name' (string, the \"simple\" table name)\n\nNote that the expression can only test against 'operations', if 'fetchAdditionalInfo' is true.\n\nHint: when filtering commits, you can determine whether commits are \"missing\" (filtered) by checking whether 'LogEntry.parentCommitHash' is different from the hash of the previous commit in the log response.", examples={@ExampleObject(ref="expr_by_commit_author"), @ExampleObject(ref="expr_by_commit_committer"), @ExampleObject(ref="expr_by_commitTime"), @ExampleObject(ref="expr_by_commit_operations_table_name"), @ExampleObject(ref="expr_by_commit_operations_type")})
    @QueryParam(value="query_expression")
    private String queryExpression;
    @Parameter(description="If set to true, will fetch additional metadata, parent commit hash and operations in a commit, for each commit.")
    @QueryParam(value="fetchAdditionalInfo")
    private boolean fetchAdditionalInfo;

    public boolean isFetchAdditionalInfo() {
        return this.fetchAdditionalInfo;
    }

    public CommitLogParams() {
    }

    private CommitLogParams(String startHash, String endHash, Integer maxRecords, String pageToken, String queryExpression, boolean fetchAdditionalInfo) {
        super(maxRecords, pageToken);
        this.startHash = startHash;
        this.endHash = endHash;
        this.queryExpression = queryExpression;
        this.fetchAdditionalInfo = fetchAdditionalInfo;
    }

    private CommitLogParams(Builder builder) {
        this(builder.startHash, builder.endHash, builder.maxRecords, builder.pageToken, builder.queryExpression, builder.fetchAdditionalInfo);
    }

    @Nullable
    public String startHash() {
        return this.startHash;
    }

    @Nullable
    public String endHash() {
        return this.endHash;
    }

    public String queryExpression() {
        return this.queryExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static CommitLogParams empty() {
        return new Builder().build();
    }

    public String toString() {
        return new StringJoiner(", ", CommitLogParams.class.getSimpleName() + "[", "]").add("startHash='" + this.startHash + "'").add("endHash='" + this.endHash + "'").add("maxRecords=" + this.maxRecords()).add("pageToken='" + this.pageToken() + "'").add("queryExpression='" + this.queryExpression + "'").add("fetchAdditionalInfo='" + this.fetchAdditionalInfo + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitLogParams that = (CommitLogParams)o;
        return Objects.equals(this.startHash, that.startHash) && Objects.equals(this.endHash, that.endHash) && Objects.equals(this.maxRecords(), that.maxRecords()) && Objects.equals(this.pageToken(), that.pageToken()) && Objects.equals(this.queryExpression, that.queryExpression) && Objects.equals(this.fetchAdditionalInfo, that.fetchAdditionalInfo);
    }

    public int hashCode() {
        return Objects.hash(this.startHash, this.endHash, this.maxRecords(), this.pageToken(), this.queryExpression, this.fetchAdditionalInfo);
    }

    public static class Builder
    extends AbstractParams.Builder<Builder> {
        private String startHash;
        private String endHash;
        private String queryExpression;
        private boolean fetchAdditionalInfo;

        private Builder() {
        }

        public Builder startHash(String startHash) {
            this.startHash = startHash;
            return this;
        }

        public Builder endHash(String endHash) {
            this.endHash = endHash;
            return this;
        }

        public Builder expression(String queryExpression) {
            this.queryExpression = queryExpression;
            return this;
        }

        public Builder fetchAdditionalInfo(boolean fetchAdditionalInfo) {
            this.fetchAdditionalInfo = fetchAdditionalInfo;
            return this;
        }

        public Builder from(CommitLogParams params) {
            return ((Builder)((Builder)this.startHash(params.startHash).endHash(params.endHash).maxRecords(params.maxRecords())).pageToken(params.pageToken())).expression(params.queryExpression).fetchAdditionalInfo(params.fetchAdditionalInfo);
        }

        private void validate() {
        }

        public CommitLogParams build() {
            this.validate();
            return new CommitLogParams(this);
        }
    }
}

