/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Objects;
import java.util.StringJoiner;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;

public class GetReferenceParams {
    @Parameter(description="name of ref to fetch", examples={@ExampleObject(ref="ref")})
    @PathParam(value="ref")
    @NotNull
    @Pattern(regexp="^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$", message="Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes")
    private @NotNull @Pattern(regexp="^(([0-9a-fA-F]{16,64})|([A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9._-])?))$", message="Reference must be either a reference name or hash, start with a letter, followed by letters, digits, a ./_- character, not end with a slash, not contain .. or consist of the hex representation of 8-32 bytes") String refName;
    @Parameter(description="If set to true, will fetch additional metadata for references.\n\nA returned Branch instance will have the following information:\n\n- numCommitsAhead (number of commits ahead of the default branch)\n\n- numCommitsBehind (number of commits behind the default branch)\n\n- commitMetaOfHEAD (the commit metadata of the HEAD commit)\n\n- commonAncestorHash (the hash of the common ancestor in relation to the default branch).\n\n- numTotalCommits (the total number of commits in this reference).\n\nA returned Tag instance will only contain the 'commitMetaOfHEAD' and 'numTotalCommits' fields.\n\nNote that computing & fetching additional metadata might be computationally expensive on the server-side, so this flag should be used with care.")
    @QueryParam(value="fetchAdditionalInfo")
    private boolean fetchAdditionalInfo;

    public GetReferenceParams() {
    }

    private GetReferenceParams(String refName, boolean fetchAdditionalInfo) {
        this.refName = refName;
        this.fetchAdditionalInfo = fetchAdditionalInfo;
    }

    private GetReferenceParams(Builder builder) {
        this(builder.refName, builder.fetchAdditionalInfo);
    }

    public boolean isFetchAdditionalInfo() {
        return this.fetchAdditionalInfo;
    }

    public String getRefName() {
        return this.refName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetReferenceParams that = (GetReferenceParams)o;
        return this.fetchAdditionalInfo == that.fetchAdditionalInfo && Objects.equals(this.refName, that.refName);
    }

    public int hashCode() {
        return Objects.hash(this.refName, this.fetchAdditionalInfo);
    }

    public String toString() {
        return new StringJoiner(", ", GetReferenceParams.class.getSimpleName() + "[", "]").add("refName='" + this.refName + "'").add("fetchAdditionalInfo=" + this.fetchAdditionalInfo).toString();
    }

    public static class Builder {
        private String refName;
        private boolean fetchAdditionalInfo;

        private Builder() {
        }

        public Builder refName(String refName) {
            this.refName = refName;
            return this;
        }

        public Builder fetchAdditionalInfo(boolean fetchAdditionalInfo) {
            this.fetchAdditionalInfo = fetchAdditionalInfo;
            return this;
        }

        private void validate() {
            Objects.requireNonNull(this.refName, "refName must be non-null");
        }

        public GetReferenceParams build() {
            this.validate();
            return new GetReferenceParams(this);
        }
    }
}

