/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.projectnessie.api.params.AbstractParams;

public class ReferencesParams
extends AbstractParams {
    @Parameter(description="If set to true, will fetch additional metadata for references.\n\nA returned Branch instance will have the following information:\n\n- numCommitsAhead (number of commits ahead of the default branch)\n\n- numCommitsBehind (number of commits behind the default branch)\n\n- commitMetaOfHEAD (the commit metadata of the HEAD commit)\n\n- commonAncestorHash (the hash of the common ancestor in relation to the default branch).\n\n- numTotalCommits (the total number of commits in this reference).\n\nA returned Tag instance will only contain the 'commitMetaOfHEAD' and 'numTotalCommits' fields.\n\nNote that computing & fetching additional metadata might be computationally expensive on the server-side, so this flag should be used with care.")
    @QueryParam(value="fetchAdditionalInfo")
    private boolean fetchAdditionalInfo;
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\nUsable variables within the expression are:\n\n- ref (Reference) describes the reference, with fields name (String), hash (String), metadata (ReferenceMetadata)\n\n- metadata (ReferenceMetadata) shortcut to ref.metadata, never null, but possibly empty\n\n- commit (CommitMeta) - shortcut to ref.metadata.commitMetaOfHEAD, never null, but possibly empty\n\n- refType (String) - the reference type, either BRANCH or TAG\n\nNote that the expression can only test attributes metadata and commit, if 'fetchAdditionalInfo' is true.", examples={@ExampleObject(ref="expr_by_refType"), @ExampleObject(ref="expr_by_ref_name"), @ExampleObject(ref="expr_by_ref_commit")})
    @QueryParam(value="query_expression")
    @Nullable
    private String queryExpression;

    public ReferencesParams() {
    }

    private ReferencesParams(Integer maxRecords, String pageToken, boolean fetchAdditionalInfo, String queryExpression) {
        super(maxRecords, pageToken);
        this.fetchAdditionalInfo = fetchAdditionalInfo;
        this.queryExpression = queryExpression;
    }

    private ReferencesParams(Builder builder) {
        this(builder.maxRecords, builder.pageToken, builder.fetchAdditionalInfo, builder.queryExpression);
    }

    public boolean isFetchAdditionalInfo() {
        return this.fetchAdditionalInfo;
    }

    public String queryExpression() {
        return this.queryExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static ReferencesParams empty() {
        return new Builder().build();
    }

    public String toString() {
        return new StringJoiner(", ", ReferencesParams.class.getSimpleName() + "[", "]").add("maxRecords=" + this.maxRecords()).add("pageToken='" + this.pageToken() + "'").add("fetchAdditionalInfo=" + this.fetchAdditionalInfo).add("queryExpression=" + this.queryExpression).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferencesParams that = (ReferencesParams)o;
        return Objects.equals(this.maxRecords(), that.maxRecords()) && Objects.equals(this.pageToken(), that.pageToken()) && Objects.equals(this.fetchAdditionalInfo, that.fetchAdditionalInfo) && Objects.equals(this.queryExpression, that.queryExpression);
    }

    public int hashCode() {
        return Objects.hash(this.maxRecords(), this.pageToken(), this.fetchAdditionalInfo, this.queryExpression);
    }

    public static class Builder
    extends AbstractParams.Builder<Builder> {
        private boolean fetchAdditionalInfo;
        private String queryExpression;

        private Builder() {
        }

        public Builder from(ReferencesParams params) {
            return ((Builder)((Builder)this.maxRecords(params.maxRecords())).pageToken(params.pageToken())).fetchAdditionalInfo(params.fetchAdditionalInfo).expression(params.queryExpression);
        }

        public Builder fetchAdditionalInfo(boolean fetchAdditionalInfo) {
            this.fetchAdditionalInfo = fetchAdditionalInfo;
            return this;
        }

        public Builder expression(String queryExpression) {
            this.queryExpression = queryExpression;
            return this;
        }

        private void validate() {
        }

        public ReferencesParams build() {
            this.validate();
            return new ReferencesParams(this);
        }
    }
}

