/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.projectnessie.client.http.ResponseContext;
import org.projectnessie.client.http.Status;
import org.projectnessie.client.rest.NessieBackendThrottledException;
import org.projectnessie.client.rest.NessieBadRequestException;
import org.projectnessie.client.rest.NessieForbiddenException;
import org.projectnessie.client.rest.NessieInternalServerException;
import org.projectnessie.client.rest.NessieNotAuthorizedException;
import org.projectnessie.client.rest.NessieServiceException;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.error.ErrorCode;
import org.projectnessie.error.ImmutableNessieError;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieError;
import org.projectnessie.error.NessieNotFoundException;

public class ResponseCheckFilter {
    public static void checkResponse(ResponseContext con, ObjectMapper mapper) throws IOException {
        NessieError error;
        Status status = con.getResponseCode();
        if (status.getCode() > 199 && status.getCode() < 300) {
            return;
        }
        try (InputStream is = con.getErrorStream();){
            error = ResponseCheckFilter.decodeErrorObject(status, is, mapper.reader());
        }
        Optional<BaseNessieClientServerException> modelException = ErrorCode.asException(error);
        if (modelException.isPresent()) {
            throw modelException.get();
        }
        switch (status) {
            case BAD_REQUEST: {
                throw new NessieBadRequestException(error);
            }
            case UNAUTHORIZED: {
                throw new NessieNotAuthorizedException(error);
            }
            case FORBIDDEN: {
                throw new NessieForbiddenException(error);
            }
            case NOT_FOUND: {
                throw new NessieNotFoundException(error);
            }
            case CONFLICT: {
                throw new NessieConflictException(error);
            }
            case TOO_MANY_REQUESTS: {
                throw new NessieBackendThrottledException(error);
            }
            case INTERNAL_SERVER_ERROR: {
                throw new NessieInternalServerException(error);
            }
        }
        throw new NessieServiceException(error);
    }

    private static NessieError decodeErrorObject(Status status, InputStream inputStream, ObjectReader reader) {
        NessieError error;
        if (inputStream == null) {
            error = ImmutableNessieError.builder().errorCode(ErrorCode.UNKNOWN).status(status.getCode()).reason(status.getReason()).message("Could not parse error object in response.").clientProcessingException(new RuntimeException("Could not parse error object in response.")).build();
        } else {
            try {
                JsonNode errorData = reader.readTree(inputStream);
                try {
                    error = reader.treeToValue((TreeNode)errorData, NessieError.class);
                }
                catch (JsonProcessingException e) {
                    error = ImmutableNessieError.builder().message(errorData.toString()).status(status.getCode()).reason(status.getReason()).clientProcessingException(e).build();
                }
            }
            catch (IOException e) {
                error = ImmutableNessieError.builder().status(status.getCode()).reason(status.getReason()).clientProcessingException(e).build();
            }
        }
        return error;
    }
}

