/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.validation.constraints.Pattern;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.projectnessie.api.params.AbstractParams;

public class RefLogParams
extends AbstractParams {
    @Nullable
    @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    @Parameter(description="Hash of the reflog (inclusive) to start from (in chronological sense), the 'far' end of the reflog, returned 'late' in the result.")
    @QueryParam(value="startHash")
    private @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String startHash;
    @Nullable
    @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes")
    @Parameter(description="Hash of the reflog (inclusive) to end at (in chronological sense), the 'near' end of the reflog, returned 'early' in the result.")
    @QueryParam(value="endHash")
    private @Pattern(regexp="^[0-9a-fA-F]{8,64}$", message="Hash must consist of the hex representation of 4-32 bytes") String endHash;
    @Nullable
    @Parameter(description="A Common Expression Language (CEL) expression. An intro to CEL can be found at https://github.com/google/cel-spec/blob/master/doc/intro.md.\n\nUsable variables within the expression are:\n\n- 'reflog' with fields 'refLogId' (string), 'refName' (string), 'commitHash' (string), 'parentRefLogId' (string), ',operation' (string), 'operationTime' (long)\n\nHint: when filtering entries, you can determine whether entries are \"missing\" (filtered) by checking whether 'ReflogResponseEntry.parentRefLogId' is different from the hash of the previous reflog in the log response.")
    @QueryParam(value="filter")
    private String filter;

    public RefLogParams() {
    }

    private RefLogParams(String startHash, String endHash, Integer maxRecords, String pageToken, String filter) {
        super(maxRecords, pageToken);
        this.startHash = startHash;
        this.endHash = endHash;
        this.filter = filter;
    }

    private RefLogParams(Builder builder) {
        this(builder.startHash, builder.endHash, builder.maxRecords, builder.pageToken, builder.filter);
    }

    @Nullable
    public String startHash() {
        return this.startHash;
    }

    @Nullable
    public String endHash() {
        return this.endHash;
    }

    @Nullable
    public String filter() {
        return this.filter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static RefLogParams empty() {
        return new Builder().build();
    }

    public String toString() {
        return new StringJoiner(", ", RefLogParams.class.getSimpleName() + "[", "]").add("startHash='" + this.startHash + "'").add("endHash='" + this.endHash + "'").add("filter='" + this.filter + "'").add("maxRecords=" + this.maxRecords()).add("pageToken='" + this.pageToken() + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RefLogParams that = (RefLogParams)o;
        return Objects.equals(this.startHash, that.startHash) && Objects.equals(this.endHash, that.endHash) && Objects.equals(this.filter, that.filter) && Objects.equals(this.maxRecords(), that.maxRecords()) && Objects.equals(this.pageToken(), that.pageToken());
    }

    public int hashCode() {
        return Objects.hash(this.startHash, this.endHash, this.filter, this.maxRecords(), this.pageToken());
    }

    public static class Builder
    extends AbstractParams.Builder<Builder> {
        private String startHash;
        private String endHash;
        private String filter;

        private Builder() {
        }

        public Builder startHash(String startHash) {
            this.startHash = startHash;
            return this;
        }

        public Builder endHash(String endHash) {
            this.endHash = endHash;
            return this;
        }

        public Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public Builder from(RefLogParams params) {
            return (Builder)((Builder)this.startHash(params.startHash).endHash(params.endHash).filter(params.filter).maxRecords(params.maxRecords())).pageToken(params.pageToken());
        }

        public RefLogParams build() {
            return new RefLogParams(this);
        }
    }
}

