/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.client.http;

import java.util.Locale;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.projectnessie.api.http.HttpTreeApi;
import org.projectnessie.api.params.CommitLogParams;
import org.projectnessie.api.params.EntriesParams;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.api.params.GetReferenceParams;
import org.projectnessie.api.params.ReferencesParams;
import org.projectnessie.client.http.HttpClient;
import org.projectnessie.client.http.HttpRequest;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.EntriesResponse;
import org.projectnessie.model.LogResponse;
import org.projectnessie.model.Merge;
import org.projectnessie.model.Operations;
import org.projectnessie.model.Reference;
import org.projectnessie.model.ReferencesResponse;
import org.projectnessie.model.Transplant;

class HttpTreeClient
implements HttpTreeApi {
    private final HttpClient client;

    public HttpTreeClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public ReferencesResponse getAllReferences(ReferencesParams params) {
        return this.client.newRequest().path("trees").queryParam("maxRecords", params.maxRecords() != null ? params.maxRecords().toString() : null).queryParam("pageToken", params.pageToken()).queryParam("fetch", FetchOption.getFetchOptionName(params.fetchOption())).queryParam("filter", params.filter()).get().readEntity(ReferencesResponse.class);
    }

    @Override
    public Reference createReference(String sourceRefName, @NotNull Reference reference) throws NessieNotFoundException, NessieConflictException {
        return this.client.newRequest().path("trees/tree").queryParam("sourceRefName", sourceRefName).post(reference).readEntity(Reference.class);
    }

    @Override
    public Reference getReferenceByName(@NotNull GetReferenceParams params) throws NessieNotFoundException {
        return this.client.newRequest().path("trees/tree/{ref}").queryParam("fetch", FetchOption.getFetchOptionName(params.fetchOption())).resolveTemplate("ref", params.getRefName()).get().readEntity(Reference.class);
    }

    @Override
    public void assignReference(@NotNull Reference.ReferenceType referenceType, @NotNull String referenceName, @NotNull String expectedHash, @Valid @NotNull Reference assignTo) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("trees/{referenceType}/{referenceName}").resolveTemplate("referenceType", referenceType.name().toLowerCase(Locale.ROOT)).resolveTemplate("referenceName", referenceName).queryParam("expectedHash", expectedHash).put(assignTo);
    }

    @Override
    public void deleteReference(@NotNull Reference.ReferenceType referenceType, @NotNull String referenceName, @NotNull String expectedHash) throws NessieConflictException, NessieNotFoundException {
        this.client.newRequest().path("trees/{referenceType}/{referenceName}").resolveTemplate("referenceType", referenceType.name().toLowerCase(Locale.ROOT)).resolveTemplate("referenceName", referenceName).queryParam("expectedHash", expectedHash).delete();
    }

    @Override
    public Branch getDefaultBranch() {
        return this.client.newRequest().path("trees/tree").get().readEntity(Branch.class);
    }

    @Override
    public LogResponse getCommitLog(@NotNull String ref, @NotNull CommitLogParams params) throws NessieNotFoundException {
        HttpRequest builder = this.client.newRequest().path("trees/tree/{ref}/log").resolveTemplate("ref", ref);
        return builder.queryParam("maxRecords", params.maxRecords() != null ? params.maxRecords().toString() : null).queryParam("pageToken", params.pageToken()).queryParam("filter", params.filter()).queryParam("startHash", params.startHash()).queryParam("endHash", params.endHash()).queryParam("fetch", FetchOption.getFetchOptionName(params.fetchOption())).get().readEntity(LogResponse.class);
    }

    @Override
    public void transplantCommitsIntoBranch(@NotNull String branchName, @NotNull String expectedHash, String message, @Valid Transplant transplant) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("trees/branch/{branchName}/transplant").resolveTemplate("branchName", branchName).queryParam("expectedHash", expectedHash).queryParam("message", message).post(transplant);
    }

    @Override
    public void mergeRefIntoBranch(@NotNull String branchName, @NotNull String expectedHash, @NotNull @Valid Merge merge) throws NessieNotFoundException, NessieConflictException {
        this.client.newRequest().path("trees/branch/{branchName}/merge").resolveTemplate("branchName", branchName).queryParam("expectedHash", expectedHash).post(merge);
    }

    @Override
    public EntriesResponse getEntries(@NotNull String refName, @NotNull EntriesParams params) throws NessieNotFoundException {
        HttpRequest builder = this.client.newRequest().path("trees/tree/{ref}/entries").resolveTemplate("ref", refName);
        return builder.queryParam("maxRecords", params.maxRecords() != null ? params.maxRecords().toString() : null).queryParam("pageToken", params.pageToken()).queryParam("filter", params.filter()).queryParam("hashOnRef", params.hashOnRef()).queryParam("namespaceDepth", params.namespaceDepth() == null ? null : String.valueOf(params.namespaceDepth())).get().readEntity(EntriesResponse.class);
    }

    @Override
    public Branch commitMultipleOperations(String branch, @NotNull String expectedHash, @NotNull Operations operations) throws NessieNotFoundException, NessieConflictException {
        return this.client.newRequest().path("trees/branch/{branchName}/commit").resolveTemplate("branchName", branch).queryParam("expectedHash", expectedHash).post(operations).readEntity(Branch.class);
    }
}

