/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.cli;

import java.net.URI;
import java.util.concurrent.Callable;
import org.projectnessie.client.NessieClientBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.client.http.HttpClientBuilder;
import org.projectnessie.error.BaseNessieClientServerException;
import picocli.CommandLine;

public abstract class AbstractCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"-u", "--uri"}, description={"Nessie API endpoint URI, defaults to http://localhost:19120/api/v1."})
    private URI uri = URI.create("http://localhost:19120/api/v1");
    @CommandLine.Option(names={"-B", "--custom-nessie-client-builder"}, hidden=true, description={"Custom implementation of org.projectnessie.client.NessieClientBuilder."})
    private Class<?> customBuilder;

    public NessieApiV1 createNessieApiInstance() {
        NessieClientBuilder<HttpClientBuilder> clientBuilder;
        if (this.customBuilder != null) {
            try {
                clientBuilder = (NessieClientBuilder)this.customBuilder.getDeclaredMethod("builder", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to use custom NessieClientBuilder", e);
            }
        } else {
            clientBuilder = HttpClientBuilder.builder();
        }
        clientBuilder.fromSystemProperties();
        if (this.uri != null) {
            clientBuilder.withUri(this.uri);
        }
        return clientBuilder.build(NessieApiV1.class);
    }

    public abstract void execute() throws BaseNessieClientServerException;

    @Override
    public final Integer call() throws Exception {
        this.execute();
        return 0;
    }
}

