/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator;

import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.model.Content;
import org.projectnessie.tools.contentgenerator.AbstractContentGeneratorTest;
import org.projectnessie.tools.contentgenerator.cli.NessieContentGenerator;

class ITGenerateContent
extends AbstractContentGeneratorTest {
    ITGenerateContent() {
    }

    @ParameterizedTest
    @EnumSource(value=Content.Type.class)
    void basicGenerateContentTest(Content.Type contentType) throws Exception {
        Assumptions.assumeTrue((contentType != Content.Type.UNKNOWN ? 1 : 0) != 0);
        int numCommits = 20;
        try (NessieApiV1 api = this.buildNessieApi();){
            String testCaseBranch = "type_" + contentType.name();
            Assertions.assertThat((int)NessieContentGenerator.runMain((String[])new String[]{"generate", "-n", Integer.toString(numCommits), "-u", NESSIE_API_URI, "-D", testCaseBranch, "--type=" + contentType.name()})).isEqualTo(0);
            Assertions.assertThat((List)((GetCommitLogBuilder)api.getCommitLog().refName(testCaseBranch)).get().getLogEntries()).hasSize(numCommits);
        }
    }
}

