/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator.cli;

import com.google.common.annotations.VisibleForTesting;
import java.io.PrintWriter;
import org.projectnessie.client.http.HttpClientException;
import org.projectnessie.error.BaseNessieClientServerException;
import org.projectnessie.tools.contentgenerator.cli.GenerateContent;
import org.projectnessie.tools.contentgenerator.cli.NessieVersionProvider;
import org.projectnessie.tools.contentgenerator.cli.ReadCommits;
import org.projectnessie.tools.contentgenerator.cli.ReadContent;
import org.projectnessie.tools.contentgenerator.cli.ReadReferences;
import picocli.CommandLine;

@CommandLine.Command(name="nessie-content-generator", mixinStandardHelpOptions=true, versionProvider=NessieVersionProvider.class, subcommands={GenerateContent.class, ReadCommits.class, ReadReferences.class, ReadContent.class, CommandLine.HelpCommand.class})
public class NessieContentGenerator {
    public static void main(String[] arguments) {
        System.exit(NessieContentGenerator.runMain(arguments));
    }

    @VisibleForTesting
    public static int runMain(String[] arguments) {
        return NessieContentGenerator.runMain(null, arguments);
    }

    @VisibleForTesting
    public static int runMain(PrintWriter out, String[] arguments) {
        CommandLine commandLine = new CommandLine(new NessieContentGenerator()).setExecutionExceptionHandler((ex, cmd, parseResult) -> {
            if (ex instanceof BaseNessieClientServerException || ex instanceof HttpClientException) {
                cmd.getErr().println(cmd.getColorScheme().errorText(ex.toString()));
            } else {
                cmd.getErr().println(cmd.getColorScheme().richStackTraceString(ex));
            }
            return cmd.getExitCodeExceptionMapper() != null ? cmd.getExitCodeExceptionMapper().getExitCode(ex) : cmd.getCommandSpec().exitCodeOnExecutionException();
        });
        if (null != out) {
            commandLine = commandLine.setOut(out);
        }
        return commandLine.execute(arguments);
    }
}

