/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Namespace;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Namespace", generator="Immutables")
@Immutable
public final class ImmutableNamespace
extends Namespace {
    private final String name;
    private final String id;
    private final List<String> elements;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNamespace(List<String> elements) {
        this.elements = elements;
        this.name = this.initShim.name();
        this.id = this.initShim.getId();
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="name")
    @JsonIgnore
    public String name() {
        InitShim shim = this.initShim;
        return shim != null ? shim.name() : this.name;
    }

    @Override
    @JsonProperty(value="id")
    @JsonIgnore
    public String getId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getId() : this.id;
    }

    @Override
    @JsonProperty(value="elements")
    public List<String> getElements() {
        return this.elements;
    }

    public final ImmutableNamespace withElements(String ... elements) {
        List<String> newValue = ImmutableNamespace.createUnmodifiableList(false, ImmutableNamespace.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableNamespace(newValue);
    }

    public final ImmutableNamespace withElements(Iterable<String> elements) {
        if (this.elements == elements) {
            return this;
        }
        List<String> newValue = ImmutableNamespace.createUnmodifiableList(false, ImmutableNamespace.createSafeList(elements, true, false));
        return new ImmutableNamespace(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNamespace && this.equalTo(0, (ImmutableNamespace)another);
    }

    private boolean equalTo(int synthetic, ImmutableNamespace another) {
        return this.name.equals(another.name) && this.id.equals(another.id) && this.elements.equals(another.elements);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.name.hashCode();
        h2 += (h2 << 5) + this.id.hashCode();
        h2 += (h2 << 5) + this.elements.hashCode();
        return h2;
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNamespace fromJson(Json json) {
        Builder builder = ImmutableNamespace.builder();
        if (json.elements != null) {
            builder.addAllElements(json.elements);
        }
        return builder.build();
    }

    public static ImmutableNamespace copyOf(Namespace instance) {
        if (instance instanceof ImmutableNamespace) {
            return (ImmutableNamespace)instance;
        }
        return ImmutableNamespace.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Namespace", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<String> elements = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Namespace instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllElements(instance.getElements());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addElements(String element) {
            this.elements.add(Objects.requireNonNull(element, "elements element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addElements(String ... elements) {
            for (String element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        @JsonProperty(value="elements")
        @CanIgnoreReturnValue
        public final Builder elements(Iterable<String> elements) {
            this.elements.clear();
            return this.addAllElements(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllElements(Iterable<String> elements) {
            for (String element : elements) {
                this.elements.add(Objects.requireNonNull(element, "elements element"));
            }
            return this;
        }

        public ImmutableNamespace build() {
            return new ImmutableNamespace(ImmutableNamespace.createUnmodifiableList(true, this.elements));
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Namespace", generator="Immutables")
    static final class Json
    extends Namespace {
        @Nullable
        List<String> elements = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="elements")
        public void setElements(List<String> elements) {
            this.elements = elements;
        }

        @Override
        @JsonIgnore
        public String name() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getElements() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="Namespace", generator="Immutables")
    private final class InitShim {
        private byte nameBuildStage = 0;
        private String name;
        private byte idBuildStage = 0;
        private String id;

        private InitShim() {
        }

        String name() {
            if (this.nameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nameBuildStage == 0) {
                this.nameBuildStage = (byte)-1;
                this.name = Objects.requireNonNull(ImmutableNamespace.super.name(), "name");
                this.nameBuildStage = 1;
            }
            return this.name;
        }

        String getId() {
            if (this.idBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.idBuildStage == 0) {
                this.idBuildStage = (byte)-1;
                this.id = Objects.requireNonNull(ImmutableNamespace.super.getId(), "id");
                this.idBuildStage = 1;
            }
            return this.id;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.nameBuildStage == -1) {
                attributes.add("name");
            }
            if (this.idBuildStage == -1) {
                attributes.add("id");
            }
            return "Cannot build Namespace, attribute initializers form cycle " + attributes;
        }
    }
}

