/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.tools.contentgenerator.AbstractContentGeneratorTest;
import org.projectnessie.tools.contentgenerator.cli.NessieContentGenerator;

class ITReadContent
extends AbstractContentGeneratorTest {
    private final String contentId = "testContentId-" + UUID.randomUUID();
    private Branch branch;

    ITReadContent() {
    }

    @BeforeEach
    void setup() throws NessieConflictException, NessieNotFoundException {
        try (NessieApiV1 api = this.buildNessieApi();){
            this.branch = this.makeCommit(api, this.contentId);
        }
    }

    @Test
    void readContent() throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintWriter out = new PrintWriter(new PrintStream(baos), true);){
            Assertions.assertThat((int)NessieContentGenerator.runMain((PrintWriter)out, (String[])new String[]{"content", "--uri", NESSIE_API_URI, "--ref", this.branch.getName(), "--key", (String)CONTENT_KEY.getElements().get(0), "--key", (String)CONTENT_KEY.getElements().get(1)})).isEqualTo(0);
            Object[] output = baos.toString(StandardCharsets.UTF_8.toString()).split("\n");
            Assertions.assertThat((Object[])output).anySatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{this.contentId}));
            Assertions.assertThat((Object[])output).anySatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{CONTENT_KEY.toString()}));
        }
    }

    @Test
    void readContentVerbose() throws UnsupportedEncodingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (PrintWriter out = new PrintWriter(new PrintStream(baos), true);){
            Assertions.assertThat((int)NessieContentGenerator.runMain((PrintWriter)out, (String[])new String[]{"content", "--uri", NESSIE_API_URI, "--ref", this.branch.getName(), "--verbose", "--key", (String)CONTENT_KEY.getElements().get(0), "--key", (String)CONTENT_KEY.getElements().get(1)})).isEqualTo(0);
            Object[] output = baos.toString(StandardCharsets.UTF_8.toString()).split("\n");
            Assertions.assertThat((Object[])output).anySatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{this.contentId}));
            Assertions.assertThat((Object[])output).anySatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{CONTENT_KEY.toString()}));
            Assertions.assertThat((Object[])output).anySatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{"key[0]: " + (String)CONTENT_KEY.getElements().get(0)}));
            Assertions.assertThat((Object[])output).anySatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{"key[1]: " + (String)CONTENT_KEY.getElements().get(1)}));
        }
    }
}

