/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.api.params;

import java.util.Objects;
import java.util.StringJoiner;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.eclipse.microprofile.openapi.annotations.media.ExampleObject;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.immutables.builder.Builder;
import org.projectnessie.api.params.MultipleNamespacesParamsBuilder;
import org.projectnessie.model.Namespace;

public class MultipleNamespacesParams {
    @Parameter(description="name of ref to fetch", examples={@ExampleObject(ref="ref")})
    @PathParam(value="ref")
    @NotNull
    @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'")
    private @NotNull @Pattern(regexp="^[A-Za-z](((?![.][.])[A-Za-z0-9./_-])*[A-Za-z0-9_-])?$", message="Reference name must start with a letter, followed by letters, digits, one of the ./_- characters, not end with a slash or dot, not contain '..'") String refName;
    @Parameter(description="the name of the namespace", examples={@ExampleObject(ref="namespaceName"), @ExampleObject(ref="emptyNamespaceName")})
    @QueryParam(value="name")
    @Nullable
    private Namespace namespace;
    @Parameter(description="a particular hash on the given ref", examples={@ExampleObject(ref="nullHash"), @ExampleObject(ref="hash")})
    @QueryParam(value="hashOnRef")
    @Nullable
    private String hashOnRef;

    public MultipleNamespacesParams() {
    }

    @Builder.Constructor
    MultipleNamespacesParams(@NotNull String refName, @Nullable Namespace namespace, @Nullable String hashOnRef) {
        this.refName = refName;
        this.namespace = namespace;
        this.hashOnRef = hashOnRef;
    }

    public String getRefName() {
        return this.refName;
    }

    @Nullable
    public Namespace getNamespace() {
        return this.namespace;
    }

    @Nullable
    public String getHashOnRef() {
        return this.hashOnRef;
    }

    public static MultipleNamespacesParamsBuilder builder() {
        return new MultipleNamespacesParamsBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MultipleNamespacesParams that = (MultipleNamespacesParams)o;
        return Objects.equals(this.refName, that.refName) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.hashOnRef, that.hashOnRef);
    }

    public int hashCode() {
        return Objects.hash(this.refName, this.namespace, this.hashOnRef);
    }

    public String toString() {
        return new StringJoiner(", ", MultipleNamespacesParams.class.getSimpleName() + "[", "]").add("refName='" + this.refName + "'").add("namespace=" + this.namespace).add("hashOnRef='" + this.hashOnRef + "'").toString();
    }
}

