/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.eclipse.microprofile.openapi.annotations.enums.SchemaType;
import org.eclipse.microprofile.openapi.annotations.media.Schema;
import org.immutables.value.Value;
import org.projectnessie.model.ImmutableGenericMetadata;

@JsonSerialize(as=ImmutableGenericMetadata.class)
@JsonDeserialize(as=ImmutableGenericMetadata.class)
@Value.Immutable
public interface GenericMetadata {
    @NotEmpty
    public String getVariant();

    @Schema(type=SchemaType.OBJECT)
    public JsonNode getMetadata();

    public static GenericMetadata of(@NotNull String variant, @NotNull JsonNode metadata) {
        return ImmutableGenericMetadata.builder().variant(variant).metadata(metadata).build();
    }
}

