/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Operation;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Operation.Put", generator="Immutables")
@Immutable
public final class ImmutablePut
implements Operation.Put {
    private final ContentKey key;
    private final Content content;
    @Nullable
    private final Content expectedContent;

    private ImmutablePut(ContentKey key, Content content, @Nullable Content expectedContent) {
        this.key = key;
        this.content = content;
        this.expectedContent = expectedContent;
    }

    @Override
    @JsonProperty(value="key")
    public ContentKey getKey() {
        return this.key;
    }

    @Override
    @JsonProperty(value="content")
    public Content getContent() {
        return this.content;
    }

    @Override
    @JsonProperty(value="expectedContent")
    @Nullable
    public Content getExpectedContent() {
        return this.expectedContent;
    }

    public final ImmutablePut withKey(ContentKey value) {
        if (this.key == value) {
            return this;
        }
        ContentKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutablePut(newValue, this.content, this.expectedContent);
    }

    public final ImmutablePut withContent(Content value) {
        if (this.content == value) {
            return this;
        }
        Content newValue = Objects.requireNonNull(value, "content");
        return new ImmutablePut(this.key, newValue, this.expectedContent);
    }

    public final ImmutablePut withExpectedContent(@Nullable Content value) {
        if (this.expectedContent == value) {
            return this;
        }
        return new ImmutablePut(this.key, this.content, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePut && this.equalTo(0, (ImmutablePut)another);
    }

    private boolean equalTo(int synthetic, ImmutablePut another) {
        return this.key.equals(another.key) && this.content.equals(another.content) && Objects.equals(this.expectedContent, another.expectedContent);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.key.hashCode();
        h2 += (h2 << 5) + this.content.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.expectedContent);
        return h2;
    }

    public String toString() {
        return "Put{key=" + this.key + ", content=" + this.content + ", expectedContent=" + this.expectedContent + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutablePut fromJson(Json json) {
        Builder builder = ImmutablePut.builder();
        if (json.key != null) {
            builder.key(json.key);
        }
        if (json.content != null) {
            builder.content(json.content);
        }
        if (json.expectedContent != null) {
            builder.expectedContent(json.expectedContent);
        }
        return builder.build();
    }

    public static ImmutablePut copyOf(Operation.Put instance) {
        if (instance instanceof ImmutablePut) {
            return (ImmutablePut)instance;
        }
        return ImmutablePut.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Operation.Put", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_CONTENT = 2L;
        private long initBits = 3L;
        @Nullable
        private ContentKey key;
        @Nullable
        private Content content;
        @Nullable
        private Content expectedContent;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Operation instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Operation.Put instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Operation instance;
            long bits = 0L;
            if (object instanceof Operation) {
                instance = (Operation)object;
                if ((bits & 1L) == 0L) {
                    this.key(instance.getKey());
                    bits |= 1L;
                }
            }
            if (object instanceof Operation.Put) {
                instance = (Operation.Put)object;
                if ((bits & 1L) == 0L) {
                    this.key(instance.getKey());
                    bits |= 1L;
                }
                this.content(instance.getContent());
                Content expectedContentValue = instance.getExpectedContent();
                if (expectedContentValue != null) {
                    this.expectedContent(expectedContentValue);
                }
            }
        }

        @JsonProperty(value="key")
        @CanIgnoreReturnValue
        public final Builder key(ContentKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="content")
        @CanIgnoreReturnValue
        public final Builder content(Content content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="expectedContent")
        @CanIgnoreReturnValue
        public final Builder expectedContent(@Nullable Content expectedContent) {
            this.expectedContent = expectedContent;
            return this;
        }

        public ImmutablePut build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePut(this.key, this.content, this.expectedContent);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build Put, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Operation.Put", generator="Immutables")
    static final class Json
    implements Operation.Put {
        @Nullable
        ContentKey key;
        @Nullable
        Content content;
        @Nullable
        Content expectedContent;

        Json() {
        }

        @JsonProperty(value="key")
        public void setKey(ContentKey key) {
            this.key = key;
        }

        @JsonProperty(value="content")
        public void setContent(Content content) {
            this.content = content;
        }

        @JsonProperty(value="expectedContent")
        public void setExpectedContent(@Nullable Content expectedContent) {
            this.expectedContent = expectedContent;
        }

        @Override
        public ContentKey getKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Content getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Content getExpectedContent() {
            throw new UnsupportedOperationException();
        }
    }
}

