/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.BaseMergeTransplant;
import org.projectnessie.model.Transplant;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Transplant", generator="Immutables")
@Immutable
public final class ImmutableTransplant
implements Transplant {
    private final String fromRefName;
    @Nullable
    private final Boolean keepIndividualCommits;
    @Nullable
    private final List<BaseMergeTransplant.MergeKeyBehavior> keyMergeModes;
    @Nullable
    private final BaseMergeTransplant.MergeBehavior defaultKeyMergeMode;
    private final List<String> hashesToTransplant;

    private ImmutableTransplant(String fromRefName, @Nullable Boolean keepIndividualCommits, @Nullable List<BaseMergeTransplant.MergeKeyBehavior> keyMergeModes, @Nullable BaseMergeTransplant.MergeBehavior defaultKeyMergeMode, List<String> hashesToTransplant) {
        this.fromRefName = fromRefName;
        this.keepIndividualCommits = keepIndividualCommits;
        this.keyMergeModes = keyMergeModes;
        this.defaultKeyMergeMode = defaultKeyMergeMode;
        this.hashesToTransplant = hashesToTransplant;
    }

    @Override
    @JsonProperty(value="fromRefName")
    public String getFromRefName() {
        return this.fromRefName;
    }

    @Override
    @JsonProperty(value="keepIndividualCommits")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public Boolean keepIndividualCommits() {
        return this.keepIndividualCommits;
    }

    @Override
    @JsonProperty(value="keyMergeModes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public List<BaseMergeTransplant.MergeKeyBehavior> getKeyMergeModes() {
        return this.keyMergeModes;
    }

    @Override
    @JsonProperty(value="defaultKeyMergeMode")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public BaseMergeTransplant.MergeBehavior getDefaultKeyMergeMode() {
        return this.defaultKeyMergeMode;
    }

    @Override
    @JsonProperty(value="hashesToTransplant")
    public List<String> getHashesToTransplant() {
        return this.hashesToTransplant;
    }

    public final ImmutableTransplant withFromRefName(String value) {
        String newValue = Objects.requireNonNull(value, "fromRefName");
        if (this.fromRefName.equals(newValue)) {
            return this;
        }
        return ImmutableTransplant.validate(new ImmutableTransplant(newValue, this.keepIndividualCommits, this.keyMergeModes, this.defaultKeyMergeMode, this.hashesToTransplant));
    }

    public final ImmutableTransplant withKeepIndividualCommits(@Nullable Boolean value) {
        if (Objects.equals(this.keepIndividualCommits, value)) {
            return this;
        }
        return ImmutableTransplant.validate(new ImmutableTransplant(this.fromRefName, value, this.keyMergeModes, this.defaultKeyMergeMode, this.hashesToTransplant));
    }

    public final ImmutableTransplant withKeyMergeModes(BaseMergeTransplant.MergeKeyBehavior ... elements) {
        if (elements == null) {
            return ImmutableTransplant.validate(new ImmutableTransplant(this.fromRefName, this.keepIndividualCommits, null, this.defaultKeyMergeMode, this.hashesToTransplant));
        }
        List<BaseMergeTransplant.MergeKeyBehavior> newValue = Arrays.asList(elements) == null ? null : ImmutableTransplant.createUnmodifiableList(false, ImmutableTransplant.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableTransplant.validate(new ImmutableTransplant(this.fromRefName, this.keepIndividualCommits, newValue, this.defaultKeyMergeMode, this.hashesToTransplant));
    }

    public final ImmutableTransplant withKeyMergeModes(@Nullable Iterable<? extends BaseMergeTransplant.MergeKeyBehavior> elements) {
        if (this.keyMergeModes == elements) {
            return this;
        }
        List<BaseMergeTransplant.MergeKeyBehavior> newValue = elements == null ? null : ImmutableTransplant.createUnmodifiableList(false, ImmutableTransplant.createSafeList(elements, true, false));
        return ImmutableTransplant.validate(new ImmutableTransplant(this.fromRefName, this.keepIndividualCommits, newValue, this.defaultKeyMergeMode, this.hashesToTransplant));
    }

    public final ImmutableTransplant withDefaultKeyMergeMode(@Nullable BaseMergeTransplant.MergeBehavior value) {
        if (this.defaultKeyMergeMode == value) {
            return this;
        }
        return ImmutableTransplant.validate(new ImmutableTransplant(this.fromRefName, this.keepIndividualCommits, this.keyMergeModes, value, this.hashesToTransplant));
    }

    public final ImmutableTransplant withHashesToTransplant(String ... elements) {
        List<String> newValue = ImmutableTransplant.createUnmodifiableList(false, ImmutableTransplant.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableTransplant.validate(new ImmutableTransplant(this.fromRefName, this.keepIndividualCommits, this.keyMergeModes, this.defaultKeyMergeMode, newValue));
    }

    public final ImmutableTransplant withHashesToTransplant(Iterable<String> elements) {
        if (this.hashesToTransplant == elements) {
            return this;
        }
        List<String> newValue = ImmutableTransplant.createUnmodifiableList(false, ImmutableTransplant.createSafeList(elements, true, false));
        return ImmutableTransplant.validate(new ImmutableTransplant(this.fromRefName, this.keepIndividualCommits, this.keyMergeModes, this.defaultKeyMergeMode, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransplant && this.equalTo(0, (ImmutableTransplant)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransplant another) {
        return this.fromRefName.equals(another.fromRefName) && Objects.equals(this.keepIndividualCommits, another.keepIndividualCommits) && Objects.equals(this.keyMergeModes, another.keyMergeModes) && Objects.equals((Object)this.defaultKeyMergeMode, (Object)another.defaultKeyMergeMode) && this.hashesToTransplant.equals(another.hashesToTransplant);
    }

    public int hashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.fromRefName.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.keepIndividualCommits);
        h2 += (h2 << 5) + Objects.hashCode(this.keyMergeModes);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.defaultKeyMergeMode);
        h2 += (h2 << 5) + this.hashesToTransplant.hashCode();
        return h2;
    }

    public String toString() {
        return "Transplant{fromRefName=" + this.fromRefName + ", keepIndividualCommits=" + this.keepIndividualCommits + ", keyMergeModes=" + this.keyMergeModes + ", defaultKeyMergeMode=" + (Object)((Object)this.defaultKeyMergeMode) + ", hashesToTransplant=" + this.hashesToTransplant + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTransplant fromJson(Json json) {
        Builder builder = ImmutableTransplant.builder();
        if (json.fromRefName != null) {
            builder.fromRefName(json.fromRefName);
        }
        if (json.keepIndividualCommits != null) {
            builder.keepIndividualCommits(json.keepIndividualCommits);
        }
        if (json.keyMergeModes != null) {
            builder.addAllKeyMergeModes(json.keyMergeModes);
        }
        if (json.defaultKeyMergeMode != null) {
            builder.defaultKeyMergeMode(json.defaultKeyMergeMode);
        }
        if (json.hashesToTransplant != null) {
            builder.addAllHashesToTransplant(json.hashesToTransplant);
        }
        return builder.build();
    }

    private static ImmutableTransplant validate(ImmutableTransplant instance) {
        instance.checkHashes();
        return instance;
    }

    public static ImmutableTransplant copyOf(Transplant instance) {
        if (instance instanceof ImmutableTransplant) {
            return (ImmutableTransplant)instance;
        }
        return ImmutableTransplant.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="Transplant", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_FROM_REF_NAME = 1L;
        private long initBits = 1L;
        @Nullable
        private String fromRefName;
        @Nullable
        private Boolean keepIndividualCommits;
        private List<BaseMergeTransplant.MergeKeyBehavior> keyMergeModes = null;
        @Nullable
        private BaseMergeTransplant.MergeBehavior defaultKeyMergeMode;
        private List<String> hashesToTransplant = new ArrayList<String>();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(BaseMergeTransplant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Transplant instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            List<BaseMergeTransplant.MergeKeyBehavior> keyMergeModesValue;
            Boolean keepIndividualCommitsValue;
            BaseMergeTransplant.MergeBehavior defaultKeyMergeModeValue;
            BaseMergeTransplant instance;
            long bits = 0L;
            if (object instanceof BaseMergeTransplant) {
                instance = (BaseMergeTransplant)object;
                if ((bits & 1L) == 0L) {
                    defaultKeyMergeModeValue = instance.getDefaultKeyMergeMode();
                    if (defaultKeyMergeModeValue != null) {
                        this.defaultKeyMergeMode(defaultKeyMergeModeValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    keepIndividualCommitsValue = instance.keepIndividualCommits();
                    if (keepIndividualCommitsValue != null) {
                        this.keepIndividualCommits(keepIndividualCommitsValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    keyMergeModesValue = instance.getKeyMergeModes();
                    if (keyMergeModesValue != null) {
                        this.addAllKeyMergeModes(keyMergeModesValue);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.fromRefName(instance.getFromRefName());
                    bits |= 8L;
                }
            }
            if (object instanceof Transplant) {
                instance = (Transplant)object;
                if ((bits & 1L) == 0L) {
                    defaultKeyMergeModeValue = instance.getDefaultKeyMergeMode();
                    if (defaultKeyMergeModeValue != null) {
                        this.defaultKeyMergeMode(defaultKeyMergeModeValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    keepIndividualCommitsValue = instance.keepIndividualCommits();
                    if (keepIndividualCommitsValue != null) {
                        this.keepIndividualCommits(keepIndividualCommitsValue);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    keyMergeModesValue = instance.getKeyMergeModes();
                    if (keyMergeModesValue != null) {
                        this.addAllKeyMergeModes(keyMergeModesValue);
                    }
                    bits |= 4L;
                }
                this.addAllHashesToTransplant(instance.getHashesToTransplant());
                if ((bits & 8L) == 0L) {
                    this.fromRefName(instance.getFromRefName());
                    bits |= 8L;
                }
            }
        }

        @JsonProperty(value="fromRefName")
        @CanIgnoreReturnValue
        public final Builder fromRefName(String fromRefName) {
            this.fromRefName = Objects.requireNonNull(fromRefName, "fromRefName");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="keepIndividualCommits")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder keepIndividualCommits(@Nullable Boolean keepIndividualCommits) {
            this.keepIndividualCommits = keepIndividualCommits;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeyMergeModes(BaseMergeTransplant.MergeKeyBehavior element) {
            if (this.keyMergeModes == null) {
                this.keyMergeModes = new ArrayList<BaseMergeTransplant.MergeKeyBehavior>();
            }
            this.keyMergeModes.add(Objects.requireNonNull(element, "keyMergeModes element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addKeyMergeModes(BaseMergeTransplant.MergeKeyBehavior ... elements) {
            if (this.keyMergeModes == null) {
                this.keyMergeModes = new ArrayList<BaseMergeTransplant.MergeKeyBehavior>();
            }
            for (BaseMergeTransplant.MergeKeyBehavior element : elements) {
                this.keyMergeModes.add(Objects.requireNonNull(element, "keyMergeModes element"));
            }
            return this;
        }

        @JsonProperty(value="keyMergeModes")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder keyMergeModes(@Nullable Iterable<? extends BaseMergeTransplant.MergeKeyBehavior> elements) {
            if (elements == null) {
                this.keyMergeModes = null;
                return this;
            }
            this.keyMergeModes = new ArrayList<BaseMergeTransplant.MergeKeyBehavior>();
            return this.addAllKeyMergeModes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllKeyMergeModes(Iterable<? extends BaseMergeTransplant.MergeKeyBehavior> elements) {
            Objects.requireNonNull(elements, "keyMergeModes element");
            if (this.keyMergeModes == null) {
                this.keyMergeModes = new ArrayList<BaseMergeTransplant.MergeKeyBehavior>();
            }
            for (BaseMergeTransplant.MergeKeyBehavior mergeKeyBehavior : elements) {
                this.keyMergeModes.add(Objects.requireNonNull(mergeKeyBehavior, "keyMergeModes element"));
            }
            return this;
        }

        @JsonProperty(value="defaultKeyMergeMode")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @CanIgnoreReturnValue
        public final Builder defaultKeyMergeMode(@Nullable BaseMergeTransplant.MergeBehavior defaultKeyMergeMode) {
            this.defaultKeyMergeMode = defaultKeyMergeMode;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHashesToTransplant(String element) {
            this.hashesToTransplant.add(Objects.requireNonNull(element, "hashesToTransplant element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addHashesToTransplant(String ... elements) {
            for (String element : elements) {
                this.hashesToTransplant.add(Objects.requireNonNull(element, "hashesToTransplant element"));
            }
            return this;
        }

        @JsonProperty(value="hashesToTransplant")
        @CanIgnoreReturnValue
        public final Builder hashesToTransplant(Iterable<String> elements) {
            this.hashesToTransplant.clear();
            return this.addAllHashesToTransplant(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllHashesToTransplant(Iterable<String> elements) {
            for (String element : elements) {
                this.hashesToTransplant.add(Objects.requireNonNull(element, "hashesToTransplant element"));
            }
            return this;
        }

        public ImmutableTransplant build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableTransplant.validate(new ImmutableTransplant(this.fromRefName, this.keepIndividualCommits, this.keyMergeModes == null ? null : ImmutableTransplant.createUnmodifiableList(true, this.keyMergeModes), this.defaultKeyMergeMode, ImmutableTransplant.createUnmodifiableList(true, this.hashesToTransplant)));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("fromRefName");
            }
            return "Cannot build Transplant, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="Transplant", generator="Immutables")
    static final class Json
    implements Transplant {
        @Nullable
        String fromRefName;
        @Nullable
        Boolean keepIndividualCommits;
        @Nullable
        List<BaseMergeTransplant.MergeKeyBehavior> keyMergeModes = null;
        @Nullable
        BaseMergeTransplant.MergeBehavior defaultKeyMergeMode;
        @Nullable
        List<String> hashesToTransplant = Collections.emptyList();

        Json() {
        }

        @JsonProperty(value="fromRefName")
        public void setFromRefName(String fromRefName) {
            this.fromRefName = fromRefName;
        }

        @JsonProperty(value="keepIndividualCommits")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setKeepIndividualCommits(@Nullable Boolean keepIndividualCommits) {
            this.keepIndividualCommits = keepIndividualCommits;
        }

        @JsonProperty(value="keyMergeModes")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setKeyMergeModes(@Nullable List<BaseMergeTransplant.MergeKeyBehavior> keyMergeModes) {
            this.keyMergeModes = keyMergeModes;
        }

        @JsonProperty(value="defaultKeyMergeMode")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setDefaultKeyMergeMode(@Nullable BaseMergeTransplant.MergeBehavior defaultKeyMergeMode) {
            this.defaultKeyMergeMode = defaultKeyMergeMode;
        }

        @JsonProperty(value="hashesToTransplant")
        public void setHashesToTransplant(List<String> hashesToTransplant) {
            this.hashesToTransplant = hashesToTransplant;
        }

        @Override
        public String getFromRefName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Boolean keepIndividualCommits() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<BaseMergeTransplant.MergeKeyBehavior> getKeyMergeModes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public BaseMergeTransplant.MergeBehavior getDefaultKeyMergeMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getHashesToTransplant() {
            throw new UnsupportedOperationException();
        }
    }
}

