/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.tools.contentgenerator;

import java.util.List;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.projectnessie.api.params.FetchOption;
import org.projectnessie.client.api.GetCommitLogBuilder;
import org.projectnessie.client.api.NessieApiV1;
import org.projectnessie.error.NessieConflictException;
import org.projectnessie.error.NessieNotFoundException;
import org.projectnessie.model.Branch;
import org.projectnessie.model.LogResponse;
import org.projectnessie.tools.contentgenerator.AbstractContentGeneratorTest;

class ITReadCommits
extends AbstractContentGeneratorTest {
    private final String contentId = "testContentId-" + UUID.randomUUID();
    private Branch branch;

    ITReadCommits() {
    }

    @BeforeEach
    void setup() throws NessieConflictException, NessieNotFoundException {
        try (NessieApiV1 api = this.buildNessieApi();){
            this.branch = this.makeCommit(api, this.contentId);
        }
    }

    @Test
    void readCommits() throws Exception {
        AbstractContentGeneratorTest.ProcessResult proc = this.runGeneratorCmd("commits", "--uri", NESSIE_API_URI, "--ref", this.branch.getName());
        Assertions.assertThat((int)proc.getExitCode()).isEqualTo(0);
        List<String> output = proc.getStdOutLines();
        Assertions.assertThat(output).anySatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{"testMessage"}));
        Assertions.assertThat(output).noneSatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{CONTENT_KEY.toString()}));
        try (NessieApiV1 api = this.buildNessieApi();){
            Assertions.assertThat((List)((GetCommitLogBuilder)api.getCommitLog().refName(this.branch.getName())).get().getLogEntries()).hasSize(1);
        }
    }

    @Test
    void readCommitsVerbose() throws Exception {
        AbstractContentGeneratorTest.ProcessResult proc = this.runGeneratorCmd("commits", "--uri", NESSIE_API_URI, "--ref", this.branch.getName(), "--verbose");
        Assertions.assertThat((int)proc.getExitCode()).isEqualTo(0);
        List<String> output = proc.getStdOutLines();
        Assertions.assertThat(output).anySatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{"testMessage"}));
        Assertions.assertThat(output).anySatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{CONTENT_KEY.toString()}));
        Assertions.assertThat(output).anySatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{"key[0]: " + (String)CONTENT_KEY.getElements().get(0)}));
        Assertions.assertThat(output).anySatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{"key[1]: " + (String)CONTENT_KEY.getElements().get(1)}));
        Assertions.assertThat(output).anySatisfy(s -> Assertions.assertThat((String)s).contains(new CharSequence[]{this.contentId}));
        try (NessieApiV1 api = this.buildNessieApi();){
            List logEntries = ((GetCommitLogBuilder)api.getCommitLog().refName(this.branch.getName())).fetch(FetchOption.ALL).get().getLogEntries();
            Assertions.assertThat((List)logEntries).hasSize(1);
            Assertions.assertThat((List)((LogResponse.LogEntry)logEntries.get(0)).getOperations()).isNotEmpty();
            Assertions.assertThat((String)((LogResponse.LogEntry)logEntries.get(0)).getParentCommitHash()).isNotNull();
        }
    }
}

